/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectCryptographyVisitor
extends BaseMessageVisitor {
    private static final Logger log = LoggerFactory.getLogger(DetectCryptographyVisitor.class);
    private ECryptographyType type = ECryptographyType.NONE;

    @Override
    public void visit(MimeMessage msg) throws Exception {
        this.reset();
        super.visit(msg);
    }

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType contentType = new ContentType(part.getContentType());
        log.trace("MIME type: {}", (Object)contentType);
        if (contentType.match("multipart/signed")) {
            this.handleSignedPart(contentType);
        } else if (contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime")) {
            this.handlePkcs7Part(contentType);
        } else if (contentType.match("application/pgp-encrypted")) {
            log.debug("Encrypted content found: {}", (Object)contentType);
            this.type = ECryptographyType.PGP;
        }
    }

    private void handleSignedPart(ContentType contentType) {
        log.debug("Signed content found: {}", (Object)contentType);
        String protocol = contentType.getParameter("protocol");
        if (protocol != null) {
            if (protocol.equalsIgnoreCase("application/pgp-signature")) {
                this.type = ECryptographyType.PGP;
            } else if (protocol.equalsIgnoreCase("application/pkcs7-signature") || protocol.equalsIgnoreCase("application/x-pkcs7-signature")) {
                this.type = ECryptographyType.SMIME;
            }
        }
        if (this.type == ECryptographyType.NONE) {
            log.warn("Signed content found, but can not determine what cryptographic method was used. Content type: {}", (Object)contentType);
        }
    }

    private void handlePkcs7Part(ContentType contentType) {
        log.debug("PKCS7 content found: {}", (Object)contentType);
        if ("signed-data".equalsIgnoreCase(contentType.getParameter("smime-type")) || "enveloped-data".equalsIgnoreCase(contentType.getParameter("smime-type"))) {
            this.type = ECryptographyType.SMIME;
        }
        if (this.type == ECryptographyType.NONE) {
            log.warn("PKCS7 crypthographic content found, but can not determine what cryptographic method was used. Content type: {}", (Object)contentType);
        }
    }

    public ECryptographyType getType() {
        return this.type;
    }

    public void reset() {
        this.type = ECryptographyType.NONE;
    }
}

