/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.encrypt.PgpMailEncryptor;
import net.savignano.snotify.atlassian.mailer.encrypt.SmimeMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpEncryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeEncryptionKeyManager;
import net.savignano.snotify.confluence.mailer.ConfluenceMailSpaceExtractor;
import net.savignano.snotify.confluence.mailer.ConfluenceUser;
import net.savignano.snotify.confluence.mailer.SnotifyI18n;
import net.savignano.snotify.confluence.mailer.keysource.smime.ConfluenceSmimeKeyManager;
import net.savignano.snotify.confluence.mailer.util.MessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailer
extends AAtlassianMailer<ConfluenceUser> {
    private static final String SNOTIFY_NAME = "S/Notify for Confluence";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailer.class);

    public ConfluenceMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties spaceProps) {
        super(session, appProps, userProps, spaceProps);
    }

    @Override
    protected MimeMessage getFailureMessage(MessageAndAddress msgAndAddress, EKeyValidity validity) throws MessagingException {
        Locale locale;
        ConfluenceUser user = (ConfluenceUser)this.getUser(msgAndAddress.address);
        LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        if (user != null) {
            log.debug("Getting locale for user: {}", (Object)user);
            locale = localeManager.getLocale(user.getActualUser());
        } else {
            log.debug("Getting default locale.");
            locale = localeManager.getSiteDefaultLocale();
        }
        log.debug("Used locale for address {}: {}", (Object)msgAndAddress.address, (Object)locale);
        I18NBean i18nBean = ((I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class)).getI18NBean(locale);
        SnotifyI18n i18n = new SnotifyI18n(i18nBean);
        MessageBuilder builder = new MessageBuilder((Message)msgAndAddress.message, this.getSession(), i18n);
        builder.additional(this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT));
        if (validity == EKeyValidity.ERROR) {
            return builder.buildInternalErrorInfoMail();
        }
        EEncryptionTypePriority type = this.getTypePriority();
        builder.encryptionType(type);
        builder.editPgpInfo(this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        builder.editSmimeInfo(this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        return builder.buildMissingKeyInfoMail();
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Address toAddress, Address fromAddress) {
        ConfluenceUser user = (ConfluenceUser)this.getUser(toAddress);
        ConfluenceSmimeKeyManager manager = user == null ? new ConfluenceSmimeKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new ConfluenceSmimeKeyManager(user, this.getAppProps(), this.getUserProps());
        SmimeEncryptionKeyManager senderManager = new SmimeEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(this.getSession(), (SnotifySmimePublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        return encryptor;
    }

    protected PgpMailEncryptor getPgpEncryptor(Address toAddress, Address fromAddress) {
        ConfluenceUser user = (ConfluenceUser)this.getUser(toAddress);
        PgpPublicKeyManager manager = user == null ? new PgpPublicKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new PgpPublicKeyManager(user, this.getAppProps(), this.getUserProps());
        PgpEncryptionKeyManager senderManager = new PgpEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        PgpMailEncryptor encryptor = new PgpMailEncryptor(this.getSession(), (SnotifyPgpPublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        Long tweakAlgorithm = this.getAppProps().getLong(EProperty.TWEAK_PGP_SYMMETRIY_KEY_ALGORITHM);
        if (tweakAlgorithm != null) {
            encryptor.setForceSymmetricKeyAlgorithm(tweakAlgorithm.intValue());
        }
        return encryptor;
    }

    @Override
    protected List<String> extractProjectKeys(MimeMessage msg) {
        Set<String> spaces;
        String msgId = MessageUtil.getMessageId(msg);
        SettingsManager manager = (SettingsManager)ComponentLocator.getComponent(SettingsManager.class);
        String baseUrl = manager.getGlobalSettings().getBaseUrl();
        ConfluenceMailSpaceExtractor extractor = new ConfluenceMailSpaceExtractor(baseUrl);
        try {
            spaces = extractor.getKeys(msg);
        }
        catch (Exception e) {
            log.error("Could not extract space keys for email " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            spaces = Collections.emptySet();
        }
        log.debug("Space reference(s) found in email {}: {}", (Object)msgId, spaces);
        return new ArrayList<String>(spaces);
    }

    @Override
    protected ConfluenceUser loadUser(Address address) {
        return ConfluenceUser.lookupUser(address);
    }

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        ConfluenceUser user;
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        String whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        if (whitelistUserGroup != null && (user = (ConfluenceUser)this.getUser(msgAndAddress.address)) != null) {
            GroupManager manager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
            try {
                Group group = manager.getGroup(whitelistUserGroup);
                if (group != null) {
                    boolean member = manager.hasMembership(group, user.getActualUser());
                    log.debug("User {} is in group {}: {}", new Object[]{user, group, member});
                    return !member;
                }
                log.warn("Group {} does not exist.", (Object)whitelistUserGroup);
            }
            catch (EntityException e) {
                log.error("Could not check if user " + user + " is in group " + whitelistUserGroup + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }
}

