/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.component.ComponentLocator;
import net.savignano.snotify.atlassian.common.ASnotifyProjectProperties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnotifySpaceProperties
extends ASnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifySpaceProperties.class);
    private BandanaManager manager;

    @Override
    protected String getString(String key, String projectName) {
        String value;
        ConfluenceBandanaContext context = this.getContext(projectName);
        try {
            value = (String)this.getManager().getValue((BandanaContext)context, key);
        }
        catch (ClassCastException e) {
            log.error("ClassCastException loading project property " + key + " for project " + projectName + ".", (Throwable)e);
            this.getManager().removeValue((BandanaContext)context, key);
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.trace("Project property \"{}\" for project {} is considered null.", (Object)key, (Object)projectName);
            return null;
        }
        log.trace("Project property \"{}\" for project {} is: {}", new Object[]{key, projectName, value});
        return value;
    }

    @Override
    protected void setString(String key, String value, String projectName) {
        ConfluenceBandanaContext context = this.getContext(projectName);
        Object oldValue = this.getManager().getValue((BandanaContext)context, key);
        if (!(oldValue == null || value != null && oldValue instanceof String)) {
            log.trace("Removing project property \"{}\" for project {}.", (Object)key, (Object)projectName);
            this.getManager().removeValue((BandanaContext)context, key);
        }
        if (value != null) {
            log.trace("Setting app property \"{}\" for project {} to: {}", new Object[]{key, projectName, value});
            this.getManager().setValue((BandanaContext)context, key, (Object)value);
        }
        if (log.isTraceEnabled()) {
            Object newValue = this.getManager().getValue((BandanaContext)context, key);
            if (value == null ? newValue != null : !value.equals(newValue)) {
                log.error("Setting of app property \"{}\" for project {} failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, projectName, value, newValue});
            }
        }
    }

    private BandanaManager getManager() {
        if (this.manager == null) {
            this.manager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        }
        return this.manager;
    }

    private ConfluenceBandanaContext getContext(String spaceKey) {
        return new ConfluenceBandanaContext(spaceKey);
    }
}

