/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import java.util.Arrays;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ExhaustedPrivateKeyException;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSSignature;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSigParameters;

class HSS {
    HSS() {
    }

    public static HSSPrivateKeyParameters generateHSSKeyPair(HSSKeyGenerationParameters parameters) {
        LMSPrivateKeyParameters[] keys = new LMSPrivateKeyParameters[parameters.getDepth()];
        LMSSignature[] sig = new LMSSignature[parameters.getDepth() - 1];
        byte[] rootSeed = new byte[32];
        parameters.getRandom().nextBytes(rootSeed);
        byte[] I = new byte[16];
        parameters.getRandom().nextBytes(I);
        byte[] zero = new byte[]{};
        long hssKeyMaxIndex = 1L;
        for (int t = 0; t < keys.length; ++t) {
            keys[t] = t == 0 ? new LMSPrivateKeyParameters(parameters.getLmsParameters()[t].getLMSigParam(), parameters.getLmsParameters()[t].getLMOTSParam(), 0, I, 1 << parameters.getLmsParameters()[t].getLMSigParam().getH(), rootSeed) : new PlaceholderLMSPrivateKey(parameters.getLmsParameters()[t].getLMSigParam(), parameters.getLmsParameters()[t].getLMOTSParam(), -1, zero, 1 << parameters.getLmsParameters()[t].getLMSigParam().getH(), zero);
            hssKeyMaxIndex *= (long)(1 << parameters.getLmsParameters()[t].getLMSigParam().getH());
        }
        if (hssKeyMaxIndex == 0L) {
            hssKeyMaxIndex = Long.MAX_VALUE;
        }
        return new HSSPrivateKeyParameters(parameters.getDepth(), Arrays.asList(keys), Arrays.asList(sig), 0L, hssKeyMaxIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementIndex(HSSPrivateKeyParameters keyPair) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(keyPair);
            keyPair.incIndex();
            keyPair.getKeys().get(keyPair.getL() - 1).incIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rangeTestKeys(HSSPrivateKeyParameters keyPair) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            int L;
            if (keyPair.getIndex() >= keyPair.getIndexLimit()) {
                throw new ExhaustedPrivateKeyException("hss private key" + (keyPair.isShard() ? " shard" : "") + " is exhausted");
            }
            int d = L = keyPair.getL();
            List<LMSPrivateKeyParameters> prv = keyPair.getKeys();
            while (prv.get(d - 1).getIndex() == 1 << prv.get(d - 1).getSigParameters().getH()) {
                if (--d != 0) continue;
                throw new ExhaustedPrivateKeyException("hss private key" + (keyPair.isShard() ? " shard" : "") + " is exhausted the maximum limit for this HSS private key");
            }
            while (d < L) {
                keyPair.replaceConsumedKey(d);
                ++d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSSignature generateSignature(HSSPrivateKeyParameters keyPair, byte[] message) {
        HSSPrivateKeyParameters hSSPrivateKeyParameters = keyPair;
        synchronized (hSSPrivateKeyParameters) {
            HSS.rangeTestKeys(keyPair);
            List<LMSPrivateKeyParameters> keys = keyPair.getKeys();
            List<LMSSignature> sig = keyPair.getSig();
            int L = keyPair.getL();
            LMSPrivateKeyParameters nextKey = keyPair.getKeys().get(L - 1);
            LMSSignature signatureResult = LMS.generateSign(nextKey, message);
            LMSSignedPubKey[] signed_pub_key = new LMSSignedPubKey[L - 1];
            for (int i = 0; i < L - 1; ++i) {
                signed_pub_key[i] = new LMSSignedPubKey(sig.get(i), keys.get(i + 1).getPublicKey());
            }
            keyPair.incIndex();
            if (L == 1) {
                return new HSSSignature(L - 1, signed_pub_key, signatureResult);
            }
            return new HSSSignature(L - 1, signed_pub_key, signatureResult);
        }
    }

    public static boolean verifySignature(HSSPublicKeyParameters publicKey, HSSSignature signature, byte[] message) {
        int Nspk = signature.getlMinus1();
        if (Nspk + 1 != publicKey.getL()) {
            return false;
        }
        LMSSignature[] sigList = new LMSSignature[Nspk + 1];
        LMSPublicKeyParameters[] pubList = new LMSPublicKeyParameters[Nspk];
        for (int i = 0; i < Nspk; ++i) {
            sigList[i] = signature.getSignedPubKey()[i].getSignature();
            pubList[i] = signature.getSignedPubKey()[i].getPublicKey();
        }
        sigList[Nspk] = signature.getSignature();
        LMSPublicKeyParameters key = publicKey.getLMSPublicKey();
        for (int i = 0; i < Nspk; ++i) {
            LMSSignature sig = sigList[i];
            byte[] msg = pubList[i].toByteArray();
            if (!LMS.verifySignature(key, sig, msg)) {
                return false;
            }
            try {
                key = pubList[i];
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
        return LMS.verifySignature(key, sigList[Nspk], message);
    }

    static class PlaceholderLMSPrivateKey
    extends LMSPrivateKeyParameters {
        public PlaceholderLMSPrivateKey(LMSigParameters lmsParameter, LMOtsParameters otsParameters, int q, byte[] I, int maxQ, byte[] masterSecret) {
            super(lmsParameter, otsParameters, q, I, maxQ, masterSecret);
        }

        LMOtsPrivateKey getNextOtsPrivateKey() {
            throw new RuntimeException("placeholder only");
        }

        public LMSPublicKeyParameters getPublicKey() {
            throw new RuntimeException("placeholder only");
        }
    }
}

