/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.RDN;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeUtil {
    public static final String X509_FACTORY_KEY = "X.509";
    private static final Logger log = LoggerFactory.getLogger(SmimeUtil.class);

    public static final String getSerialNumber(X509Certificate certificate) {
        if (certificate == null) {
            log.debug("Null value given for certificate.");
            return "<N/A>";
        }
        BigInteger serialNumber = certificate.getSerialNumber();
        if (serialNumber == null) {
            log.warn("No serial number in certificate. Might be corrupt. Certificate: {}", (Object)certificate);
            return "<N/A>";
        }
        return serialNumber.toString(10) + " (0x" + serialNumber.toString(16) + ")";
    }

    public static final boolean isSupportedSymmetricKeyAlgorithm(ASN1ObjectIdentifier algorithm) {
        if (algorithm == null) {
            return false;
        }
        return !algorithm.equals(CMSAlgorithm.DES_CBC);
    }

    public static final boolean isSupportedAsymmetricKeyAlgorithm(ASN1ObjectIdentifier algorithm) {
        return algorithm != null;
    }

    public static final boolean isMessageEncrypted(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME encrypted. Encountered message class: {}", message.getClass());
            return false;
        }
        return SmimeUtil.isMessageEncrypted((MimePart)message);
    }

    private static final boolean isMessageEncrypted(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) {
                return "enveloped-data".equalsIgnoreCase(type.getParameter("smime-type"));
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final boolean isMessageSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        MimePart part = (MimePart)message;
        return SmimeUtil.isMessageTransparentSigned(part) || SmimeUtil.isMessageOpaqueSigned(part);
    }

    public static final boolean isMessageOpaqueSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return SmimeUtil.isMessageOpaqueSigned((MimePart)message);
    }

    public static final boolean isMessageTransparentSigned(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be S/MIME signed. Encountered message class: {}", message.getClass());
            return false;
        }
        return SmimeUtil.isMessageTransparentSigned((MimePart)message);
    }

    private static final boolean isMessageOpaqueSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) {
                return "signed-data".equalsIgnoreCase(type.getParameter("smime-type"));
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static final boolean isMessageTransparentSigned(MimePart part) {
        try {
            ContentType type = new ContentType(part.getContentType());
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                return protocol != null && (protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"));
            }
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static final X509Certificate createCertificate(byte[] content) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        CertificateFactory fact = CertificateFactory.getInstance(X509_FACTORY_KEY);
        return (X509Certificate)fact.generateCertificate(is);
    }

    public static final List<String> getAliasesForEmail(KeyStore keyStore, String email) {
        return SmimeUtil.getAliasesForEmail(keyStore, email, EKeyPurpose.UNDEFINED);
    }

    public static final List<String> getAliasesForEmail(KeyStore keyStore, String email, EKeyPurpose purpose) {
        Enumeration<String> aliases;
        if (keyStore == null || email == null || purpose == null) {
            return Collections.emptyList();
        }
        log.debug("Retrieving aliases from key store for email <{}> with purpose {}.", (Object)email, (Object)purpose);
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            log.error("Error getting aliases from Key Store: " + keyStore, (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<String> aliasesList = new ArrayList<String>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            log.trace("Checking alias: {}", (Object)alias);
            X509Certificate certificate = null;
            try {
                certificate = SmimeUtil.getCertForAlias(keyStore, alias);
            }
            catch (KeyStoreException e) {
                log.error("Error getting certificate for alias: " + alias, (Throwable)e);
                continue;
            }
            boolean certForEmail = false;
            try {
                certForEmail = SmimeUtil.isCertForEmail(certificate, email);
            }
            catch (CertificateEncodingException e) {
                log.error("Error extracting the information from certificate: " + certificate, (Throwable)e);
                continue;
            }
            catch (CertificateParsingException e) {
                log.error("Subject Alternative Names Extension could not be parsed from certificate: " + certificate, (Throwable)e);
                continue;
            }
            if (!certForEmail || purpose != EKeyPurpose.UNDEFINED && !SmimeUtil.isCertForPurpose(certificate, purpose)) continue;
            log.trace("Certificate with serial number {} provided by alias {} belongs to email <{}>.", new Object[]{SmimeUtil.getSerialNumber(certificate), alias, email});
            aliasesList.add(alias);
        }
        log.debug("Found aliases in key store for email <{}>: {}", (Object)email, aliasesList);
        return aliasesList;
    }

    public static final X509Certificate getValidCertForEmail(KeyStore keyStore, String email) {
        return SmimeUtil.getValidCertForEmail(keyStore, email, EKeyPurpose.UNDEFINED);
    }

    public static final X509Certificate getValidCertForEmail(KeyStore keyStore, String email, EKeyPurpose purpose) {
        if (keyStore == null || email == null || purpose == null) {
            return null;
        }
        X509Certificate chosenCertificate = null;
        for (String alias : SmimeUtil.getAliasesForEmail(keyStore, email, purpose)) {
            X509Certificate certificate;
            try {
                certificate = SmimeUtil.getCertForAlias(keyStore, alias);
            }
            catch (KeyStoreException e) {
                log.error("Error getting certificate for alias: " + alias, (Throwable)e);
                continue;
            }
            try {
                certificate.checkValidity();
                log.debug("Found valid certificate for email <{}>. Serial number: {}", (Object)email, (Object)SmimeUtil.getSerialNumber(certificate));
                if (chosenCertificate != null) {
                    if (!certificate.getNotAfter().after(chosenCertificate.getNotAfter())) continue;
                    chosenCertificate = certificate;
                    continue;
                }
                chosenCertificate = certificate;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                log.debug("Found invalid certificate for email <{}>: {}", (Object)email, (Object)SmimeUtil.getSerialNumber(certificate));
            }
        }
        log.debug("Found certificate for email <{}>: {}", (Object)email, chosenCertificate);
        return chosenCertificate;
    }

    public static final X509Certificate getCertForEmail(KeyStore keyStore, String email) throws KeyStoreException, CertificateException {
        log.debug("Looking up certificate in key store for email: <{}>", (Object)email);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            log.trace("Checking alias: {}", (Object)alias);
            X509Certificate certificate = SmimeUtil.getCertForAlias(keyStore, alias);
            if (!SmimeUtil.isCertForEmail(certificate, email)) continue;
            log.debug("Certificate with serial number {} found in key store.", (Object)SmimeUtil.getSerialNumber(certificate));
            return certificate;
        }
        log.debug("Found no certificate in key store for email: <{}>", (Object)email);
        return null;
    }

    private static final X509Certificate getCertForAlias(KeyStore keyStore, String alias) throws KeyStoreException {
        Certificate cert = keyStore.getCertificate(alias);
        if (!(cert instanceof X509Certificate)) {
            log.warn("Certificate found for alias \"{}\" is not a X509Certificate. It will be skipped. Found certificate: {}", (Object)alias, (Object)cert);
            return null;
        }
        return (X509Certificate)cert;
    }

    public static final PrivateKey getPrivateKeyForCert(KeyStore keyStore, X509Certificate cert, char[] password) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (keyStore == null || cert == null) {
            return null;
        }
        log.debug("Getting private key for certificate with serial number: {}", (Object)SmimeUtil.getSerialNumber(cert));
        String alias = keyStore.getCertificateAlias(cert);
        log.debug("Found alias: {}", (Object)alias);
        PrivateKey privateKey = null;
        if (alias != null) {
            Key key = keyStore.getKey(alias, password);
            if (key == null) {
                log.info("No private key found for alias {} in key store.", (Object)alias);
            } else if (key instanceof PrivateKey) {
                log.trace("Found private key: {}", (Object)key);
                privateKey = (PrivateKey)key;
            } else {
                log.warn("Key for alias {} is not a PrivateKey, but: {}", (Object)alias, key.getClass());
            }
        }
        return privateKey;
    }

    public static final String[] getEmails(X509Certificate certificate) throws CertificateEncodingException, CertificateParsingException {
        if (certificate == null) {
            return new String[0];
        }
        String[] emails = SmimeUtil.getEmails(SmimeUtil.getSubject(certificate), certificate.getSubjectAlternativeNames());
        log.trace("Emails of subject from certificate with serial number {}: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)emails);
        return emails;
    }

    public static final String[] getIssuerEmails(X509Certificate certificate) throws CertificateEncodingException, CertificateParsingException {
        if (certificate == null) {
            return new String[0];
        }
        String[] emails = SmimeUtil.getEmails(SmimeUtil.getIssuer(certificate), certificate.getIssuerAlternativeNames());
        log.trace("Emails of issuer from certificate with serial number {}: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)emails);
        return emails;
    }

    private static final String[] getEmails(X500Name name, Collection<List<?>> altNames) {
        String email;
        LinkedHashSet<String> emails = new LinkedHashSet<String>();
        if (name != null && (email = SmimeUtil.getRDNValue(name, BCStyle.E)) != null) {
            emails.add(email);
        }
        if (altNames != null) {
            for (List<?> item : altNames) {
                int type = (Integer)item.get(0);
                Object value = item.get(1);
                if (type != 1 || value == null) continue;
                emails.add(value.toString());
            }
        }
        return emails.toArray(new String[emails.size()]);
    }

    public static final boolean isCertForPurpose(X509Certificate cert, EKeyPurpose purpose) {
        boolean result;
        if (cert == null || purpose == null) {
            return false;
        }
        log.debug("Checking purpose {} for certificate with serial number: {}", (Object)purpose, (Object)SmimeUtil.getSerialNumber(cert));
        Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
        if (criticalExtensions != null && criticalExtensions.contains("2.5.29.37")) {
            try {
                List<String> extendedKeyUsage = cert.getExtendedKeyUsage();
                if (extendedKeyUsage == null || !extendedKeyUsage.contains("1.3.6.1.5.5.7.3.4")) {
                    log.debug("Extended Key Usage for certificate is critical, but does not contain 'Email'.");
                    return false;
                }
            }
            catch (CertificateParsingException e) {
                log.error("Could not parse 'Extended Key Usage' extension of certificate " + SmimeUtil.getSerialNumber(cert) + ". Error message: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        if (criticalExtensions == null || !criticalExtensions.contains("2.5.29.15")) {
            log.debug("Key usage is not critical.");
            return true;
        }
        boolean[] usage = cert.getKeyUsage();
        switch (purpose) {
            case DECRYPTION: 
            case ENCRYPTION: {
                result = usage[2];
                break;
            }
            case SIGNING: {
                result = usage[0];
                break;
            }
            case UNDEFINED: {
                result = false;
                break;
            }
            default: {
                throw new IllegalStateException("Handling of key purpose " + (Object)((Object)purpose) + " not yet implemented.");
            }
        }
        log.debug("Certificate is usable: {}", (Object)result);
        return result;
    }

    public static final boolean isCertForEmail(X509Certificate certificate, String email) throws CertificateEncodingException, CertificateParsingException {
        if (email == null) {
            return false;
        }
        for (String foundEmail : SmimeUtil.getEmails(certificate)) {
            if (!email.equalsIgnoreCase(foundEmail)) continue;
            return true;
        }
        return false;
    }

    public static final X500Name getIssuer(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getIssuer();
    }

    public static final X500Name getSubject(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getSubject();
    }

    public static final String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }

    public static final KeyStore convertToKeyStore(Store<X509CertificateHolder> store, String type, char[] password) throws KeyStoreException, CertificateException {
        KeyStore convertedKeyStore = KeyStore.getInstance(type, SecurityUtil.getProvider());
        try {
            convertedKeyStore.load(null, password);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("Failed to create key store. Error message: " + e.getMessage(), (Throwable)e);
        }
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider(SecurityUtil.getProvider());
        Collection<X509CertificateHolder> allHolders = store.getMatches(null);
        log.debug("Converting {} certificates.", (Object)allHolders.size());
        for (X509CertificateHolder holder : allHolders) {
            String alias = holder.getIssuer().toString() + holder.getSerialNumber().toString();
            log.trace("Adding certificate with alias \"{}\" to key store.", (Object)alias);
            X509Certificate cert = converter.getCertificate(holder);
            convertedKeyStore.setCertificateEntry(alias, cert);
        }
        log.debug("Added all certificates to key store.");
        return convertedKeyStore;
    }

    public static final String getCmsName(ASN1ObjectIdentifier algorithm) {
        if (algorithm == null) {
            return "null";
        }
        if (algorithm.equals(CMSAlgorithm.AES128_CBC)) {
            return "AES128-CBC";
        }
        if (algorithm.equals(CMSAlgorithm.AES192_CBC)) {
            return "AES192-CBC";
        }
        if (algorithm.equals(CMSAlgorithm.AES256_CBC)) {
            return "AES256-CBC";
        }
        if (algorithm.equals(CMSAlgorithm.AES128_GCM)) {
            return "AES128-GCM";
        }
        if (algorithm.equals(CMSAlgorithm.AES192_GCM)) {
            return "AES192-GCM";
        }
        if (algorithm.equals(CMSAlgorithm.AES256_GCM)) {
            return "AES256-GCM";
        }
        if (algorithm.equals(CMSAlgorithm.DES_CBC)) {
            return "DES-CBC";
        }
        if (algorithm.equals(CMSAlgorithm.DES_EDE3_CBC)) {
            return "DES-EDE3-CBC";
        }
        if (algorithm.equals(CMSAlgorithm.CAST5_CBC)) {
            return "CAST5-CBC";
        }
        if (algorithm.equals(PKCSObjectIdentifiers.rsaEncryption)) {
            return "RSA";
        }
        return "Unknown (" + algorithm.getId() + ")";
    }
}

