/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyManager<T extends ISnotifyKey<?>>
implements IKeyManager<T> {
    private static final Logger log = LoggerFactory.getLogger(AKeyManager.class);
    private final String address;
    private final ISnotifyAppProperties appProps;

    public AKeyManager(String address, ISnotifyAppProperties appProps) {
        this.address = address;
        this.appProps = appProps;
    }

    @Override
    public T getKey() {
        boolean cacheStale;
        T cachedKey = this.getCachedKey();
        log.debug("Cached key for address <{}>: {}", (Object)this.getAddress(), cachedKey);
        boolean cacheAutoExpire = this.isCacheAutomaticallyExpired();
        boolean cacheManualExpire = this.isCacheManuallyExpired();
        boolean bl = cacheStale = cacheAutoExpire || cacheManualExpire;
        if (!cacheStale && this.isCachedKeyUsable(cachedKey)) {
            log.debug("Cached key will be used.");
            return cachedKey;
        }
        T key = this.loadKey();
        log.debug("Loaded key for address <{}>: {}", (Object)this.getAddress(), key);
        if (!key.isValid() && cachedKey.isValid() && !cacheManualExpire && this.isCachedKeyUsable(cachedKey)) {
            log.debug("Using cached key instead of loaded key.");
            key = cachedKey;
        }
        if (key != cachedKey && cacheStale && this.isKeyCachable(key)) {
            log.debug("Storing of key is needed.");
            try {
                this.setCachedKey(key.isValid() ? key : null);
            }
            catch (IOException e) {
                log.error("Key could not be stored. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return key;
    }

    private T loadKey() {
        ISnotifyKey bestKey = null;
        for (Supplier<Optional<IKeyLoader<T>>> supplier : this.getKeyLoaders()) {
            T key;
            Optional<IKeyLoader<T>> optional = supplier.get();
            if (!optional.isPresent()) continue;
            IKeyLoader<T> loader = optional.get();
            try {
                log.debug("Loading key from location: {}", (Object)loader.getKeySource());
                key = loader.loadKey();
            }
            catch (Exception e) {
                log.error("Unexpected error retrieving key from: " + loader + ". Error message: " + e.getMessage(), (Throwable)e);
                key = this.getValidityKey(EKeyValidity.ERROR, loader.getKeySource());
            }
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = (ISnotifyKey)key;
                break;
            }
            if (bestKey == null) {
                bestKey = (ISnotifyKey)key;
                continue;
            }
            if (key.getKeyValidity().ordinal() >= bestKey.getKeyValidity().ordinal()) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = (ISnotifyKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        return (T)bestKey;
    }

    protected boolean isCacheAutomaticallyExpired() {
        return false;
    }

    protected boolean isCacheManuallyExpired() {
        return false;
    }

    protected boolean isCachedKeyUsable(T key) {
        return true;
    }

    protected boolean isKeyCachable(T key) {
        return key.getKeyValidity() != EKeyValidity.ERROR;
    }

    protected abstract T getCachedKey();

    protected abstract void setCachedKey(T var1) throws IOException;

    protected abstract Iterable<Supplier<Optional<IKeyLoader<T>>>> getKeyLoaders();

    protected abstract T getValidityKey(EKeyValidity var1, EKeySource var2);

    public String getAddress() {
        return this.address;
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }
}

