/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyStoreLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpEncryptionKeyManager
extends AKeyManager<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpEncryptionKeyManager.class);
    private static final Map<String, SnotifyPgpPublicKey> keyCache = new HashMap<String, SnotifyPgpPublicKey>();
    private static final Map<String, Calendar> timeCache = new HashMap<String, Calendar>();

    public PgpEncryptionKeyManager(String address, ISnotifyAppProperties appProps) {
        super(address, appProps);
    }

    @Override
    protected SnotifyPgpPublicKey getCachedKey() {
        return keyCache.getOrDefault(this.getAddress(), this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(SnotifyPgpPublicKey key) throws IOException {
        if (key != null) {
            keyCache.put(this.getAddress(), key);
        } else {
            keyCache.remove(this.getAddress());
        }
        timeCache.put(this.getAddress(), Calendar.getInstance());
    }

    @Override
    protected boolean isCacheAutomaticallyExpired() {
        if (super.isCacheAutomaticallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != this.getCachedTimeStamp().get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired() {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > this.getCachedTimeStamp().getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected Iterable<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifyPgpPublicKey>> createKeyStoreLoader() {
        PGPPublicKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PRIVATE_PGP_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP private keys from.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadPublicKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpPublicKeyStoreLoader(keyRings, this.getAddress()));
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifyPgpPublicKey(validity, keySource);
    }

    protected Calendar getCachedTimeStamp() {
        return timeCache.get(this.getAddress());
    }

    protected void setCachedTimeStamp(Calendar cachedTimeStamp) {
        timeCache.put(this.getAddress(), cachedTimeStamp);
    }
}

