/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpLdapLoader
extends AKeyLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpLdapLoader.class);
    private static final String PGP_KEY_SERVER_DN = "cn=PGPServerInfo";
    private static final String PGP_KEY_DN_FIELD = "pgpBaseKeySpaceDN";
    private static final String PGP_KEY_FIELD = "pgpKey";
    private static final String PGP_USER_ID_FIELD = "pgpUserId";
    private final LdapConnector connector;
    private String email;

    public PgpLdapLoader(LdapConnector connector) {
        this(connector, null);
    }

    public PgpLdapLoader(LdapConnector connector, String email) {
        this.connector = connector;
        this.email = email;
        if (connector == null) {
            throw new IllegalArgumentException("LDAP connector must not be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        if (this.getEmail() == null) {
            log.warn("No email given to look up PGP key for in LDAP.");
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Looking up PGP key for email <{}> in LDAP.", (Object)this.getEmail());
        DirContext context = null;
        try {
            log.debug("Connecting to LDAP server: {}", (Object)this.connector.getLdapUrl());
            this.connector.connect(this.createEnvironment());
            context = this.connector.getContext();
            List<Attribute> attributes = this.getKeyAttributes(context);
            SnotifyPgpPublicKey key = this.getKey(attributes);
            log.info("Key for <{}> in LDAP: {}", (Object)this.getEmail(), (Object)key);
            SnotifyPgpPublicKey snotifyPgpPublicKey = key;
            return snotifyPgpPublicKey;
        }
        catch (NamingException e) {
            log.warn("Error retrieving PGP key for email " + this.getEmail() + " in LDAP. Error message: " + e.getMessage(), (Throwable)e);
            SnotifyPgpPublicKey snotifyPgpPublicKey = this.getValidityKey(EKeyValidity.ERROR);
            return snotifyPgpPublicKey;
        }
        finally {
            log.debug("Disconnecting from LDAP server.");
            this.connector.disconnect();
        }
    }

    private Hashtable<String, String> createEnvironment() {
        return new Hashtable<String, String>();
    }

    private List<Attribute> getKeyAttributes(DirContext context) throws NamingException {
        String pgpKeyDn = this.getPgpKeyDn(context);
        if (pgpKeyDn == null) {
            throw new NamingException("No PGP Base DN found. LDAP does probably not support PGP keys.");
        }
        log.info("DN to search PGP keys in: {}", (Object)pgpKeyDn);
        SearchControls searchControl = new SearchControls(2, 0L, 10000, new String[]{PGP_KEY_FIELD}, false, false);
        String filter = "(pgpUserId=*<" + this.getEmail() + ">)";
        log.debug("Used filter: {}", (Object)filter);
        ArrayList<Attribute> keyAttributes = new ArrayList<Attribute>();
        NamingEnumeration<SearchResult> results = context.search(pgpKeyDn, filter, searchControl);
        while (results.hasMore()) {
            SearchResult result = results.next();
            log.debug("Found PGP key at: {}", (Object)result.getName());
            keyAttributes.add(result.getAttributes().get(PGP_KEY_FIELD));
        }
        log.debug("{} PGP key(s) found", (Object)keyAttributes.size());
        return keyAttributes;
    }

    private SnotifyPgpPublicKey getKey(List<Attribute> attributes) throws NamingException {
        SnotifyPgpPublicKey bestKey = null;
        for (Attribute attribute : attributes) {
            SnotifyPgpPublicKey key = this.getKey(attribute);
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = key;
                break;
            }
            if (bestKey == null) {
                bestKey = key;
                continue;
            }
            if (key.getKeyValidity().ordinal() >= bestKey.getKeyValidity().ordinal()) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return bestKey;
    }

    private SnotifyPgpPublicKey getKey(Attribute attribute) throws NamingException {
        String keyString = (String)attribute.get();
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(keyRing, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            log.error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    private List<String> getBaseDns(DirContext context) throws NamingException {
        log.debug("Looking up naming contexts in LDAP.");
        Attributes attrs = context.getAttributes("", new String[]{"namingContexts"});
        Attribute attr = attrs.get("namingContexts");
        ArrayList<String> baseDns = new ArrayList<String>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String baseDn = (String)attr.get(i);
            log.trace("Base DN: {}", (Object)baseDn);
            baseDns.add(baseDn);
        }
        return baseDns;
    }

    private String getPgpKeyDn(DirContext context) throws NamingException {
        List<String> baseDns = this.getBaseDns(context);
        log.debug("Looking up PGP server info in LDAP.");
        String pgpKeyDn = null;
        if (baseDns.contains(PGP_KEY_SERVER_DN)) {
            pgpKeyDn = this.getPgpKeyDn(context, PGP_KEY_SERVER_DN);
        } else {
            for (String baseDn : baseDns) {
                String keyInfoDn = "cn=PGPServerInfo," + baseDn;
                try {
                    pgpKeyDn = this.getPgpKeyDn(context, keyInfoDn);
                }
                catch (NameNotFoundException e) {
                    log.debug("Pgp server info not found at: " + keyInfoDn, (Throwable)e);
                }
                if (pgpKeyDn == null) continue;
                break;
            }
        }
        return pgpKeyDn;
    }

    private String getPgpKeyDn(DirContext context, String dn) throws NamingException {
        log.debug("Looking up PGP server info at: {}", (Object)dn);
        Attributes attrs = context.getAttributes(dn, new String[]{PGP_KEY_DN_FIELD});
        Attribute attr = attrs.get(PGP_KEY_DN_FIELD);
        return (String)attr.get();
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.LDAP;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return "PgpVksLdapLoader [connector=" + this.connector + ", email=" + this.email + "]";
    }
}

