/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyStoreLoader
extends AKeyLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyStoreLoader.class);
    private final PGPPublicKeyRingCollection keyRings;
    private final String email;

    public PgpPublicKeyStoreLoader(PGPPublicKeyRingCollection keyStore, String email) {
        this.keyRings = keyStore;
        this.email = email;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        log.info("Looking up PGP public key for email <{}> in key rings.", (Object)this.getEmail());
        PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(this.getKeyRings(), this.getEmail());
        if (keyRing != null) {
            log.info("Found valid PGP public key ring for email <{}> in key store.", (Object)this.getEmail());
            log.trace("Found PGP public key ring: {}", (Object)keyRing);
            SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(keyRing, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        log.info("Found no PGP public key for email {} in key store.", (Object)this.getEmail());
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }

    public PGPPublicKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "PgpPublicKeyStoreLoader [keyRings=" + this.keyRings + ", email=" + this.email + "]";
    }
}

