/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.security.KeyStore;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeDecryptionKey;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyLoader;

public class SmimeDecryptionKeyStoreLoader
extends AKeyLoader<SnotifySmimeDecryptionKey> {
    private final KeyStore keyStore;
    private final char[] password;

    public SmimeDecryptionKeyStoreLoader(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
    }

    @Override
    protected SnotifySmimeDecryptionKey loadInternalKey() throws Exception {
        SnotifySmimeDecryptionKey key = new SnotifySmimeDecryptionKey(this.keyStore, this.password);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SnotifySmimeDecryptionKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimeDecryptionKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimeDecryptionKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****]";
    }
}

