/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyLoader;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeSignKeyStoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeSignKeyManager
extends APrivateKeyManager<SnotifySmimeSignKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeSignKeyManager.class);

    public SmimeSignKeyManager(String address, ISnotifyAppProperties appProps) {
        super(address, appProps);
    }

    @Override
    protected List<Supplier<Optional<IKeyLoader<SnotifySmimeSignKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimeSignKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimeSignKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimeSignKey>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No private key store specified. Can't get decryption from key store.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            SecurityUtil.clearPassword(keyPassword);
            log.debug("Loaded key store from location \"{}\" succesfully.", (Object)location);
            return Optional.of(new SmimeSignKeyStoreLoader(ks, null, this.getAddress()));
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    protected SnotifySmimeSignKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifySmimeSignKey(validity, keySource);
    }

    @Override
    protected Class<SnotifySmimeSignKey> getCacheClass() {
        return SnotifySmimeSignKey.class;
    }
}

