/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureRemover
extends BaseMessageVisitor {
    private static final Logger log = LoggerFactory.getLogger(SignatureRemover.class);
    private String msgId;

    @Override
    public void visit(MimeMessage msg) throws Exception {
        this.msgId = MessageUtil.getMessageId(msg);
        super.visit(msg);
        this.msgId = null;
    }

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType type = new ContentType(part.getContentType());
        log.trace("MIME type: {}", (Object)type);
        if (type.match("multipart/signed")) {
            log.debug("Found '{}' content. Removing signature.", (Object)type);
            log.info("Removing signature from message {}.", (Object)this.msgId);
            Multipart mp = (Multipart)part.getContent();
            BodyPart contentPart = mp.getBodyPart(0);
            this.removeSignature((MimeBodyPart)contentPart, part);
        } else if ((type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) && "signed-data".equalsIgnoreCase(type.getParameter("smime-type"))) {
            log.debug("Found '{}' content. Removing opaque signature.", (Object)type);
            log.info("Removing signature from message {}.", (Object)this.msgId);
            SMIMESigned smimeSigned = new SMIMESigned((Part)part);
            MimeBodyPart content = smimeSigned.getContent();
            this.removeSignature(content, part);
        }
    }

    private void removeSignature(MimeBodyPart contentPart, MimePart parentPart) throws MessagingException, IOException {
        parentPart.setDisposition(null);
        parentPart.removeHeader("Content-Transfer-Encoding");
        parentPart.setContent(contentPart.getContent(), contentPart.getContentType());
        MessageUtil.copyAllHeaders((Part)contentPart, (Part)parentPart);
        this.setChanged(true);
    }
}

