/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.connector;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnector {
    private static final String DEFAULT_USERNAME_KEY = "uid";
    private static final String LDAP_URL_PROP = "ldap.url";
    private static final String LDAP_SECURE_PROP = "ldap.secure";
    private static final String LDAP_BASEDN_PROP = "ldap.basedn";
    private static final String LDAP_USERDN_PROP = "ldap.user.dn";
    private static final String LDAP_USERNAME_PROP = "ldap.user.username";
    private static final String LDAP_USERFILTER_PROP = "ldap.user.filter";
    private static final String LDAP_LOGIN_USER_PROP = "ldap.userdn";
    private static final String LDAP_LOGIN_PASSWORD_PROP = "ldap.password";
    private static final Logger log = LoggerFactory.getLogger(LdapConnector.class);
    private String userNameKey = "uid";
    private String ldapUrl;
    private String userBase;
    private String filter;
    private boolean ssl;
    private String loginUser;
    private String loginPassword;
    private DirContext context;

    public static boolean isConnector(Directory directory) {
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            if (log.isDebugEnabled()) {
                if (directory == null) {
                    log.debug("Null directory given.");
                } else if (!directory.isActive()) {
                    log.debug("Directory {} is not active.", (Object)directory.getName());
                } else if (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
                    log.debug("Directory {} is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: {}", (Object)directory.getName(), (Object)directory.getType());
                } else {
                    log.debug("Unknown reason why directory is considered unsuitable to create a connector. Probably implementation problem. Given directory: {}", (Object)directory);
                }
            }
            return false;
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        boolean isLdap = !StringUtils.isBlank((String)ldapUrl) && !StringUtils.isBlank((String)ldapBaseDn);
        log.debug("Directory {} is considered to be an LDAP: {}", (Object)directory.getName(), (Object)isLdap);
        return isLdap;
    }

    public static LdapConnector createConnector(Directory directory) throws ConfigurationException {
        if (directory == null || !directory.isActive() || directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING) {
            String reason = directory == null ? "Null directory given." : (!directory.isActive() ? "Directory " + directory.getName() + " is not active." : (directory.getType() != DirectoryType.CONNECTOR && directory.getType() != DirectoryType.DELEGATING ? "Directory " + directory.getName() + " is not of type 'CONNECTOR' nor 'DELEGATING'. Type found: " + directory.getType() : "Unknown reason why data extraction is skipped. Probably implementation problem. Given directory: " + directory));
            throw new ConfigurationException(reason);
        }
        String ldapUrl = directory.getValue(LDAP_URL_PROP);
        log.trace("LDAP URL: {}", (Object)ldapUrl);
        String ldapSecure = directory.getValue(LDAP_SECURE_PROP);
        log.trace("LDAP Secure: {}", (Object)ldapSecure);
        String ldapBaseDn = directory.getValue(LDAP_BASEDN_PROP);
        log.trace("LDAP Base DN: {}", (Object)ldapBaseDn);
        String ldapUserDn = directory.getValue(LDAP_USERDN_PROP);
        log.trace("LDAP User DN: {}", (Object)ldapUserDn);
        String ldapLoginUser = directory.getValue(LDAP_LOGIN_USER_PROP);
        log.trace("LDAP Login User: {}", (Object)ldapLoginUser);
        String ldapLoginPassword = directory.getValue(LDAP_LOGIN_PASSWORD_PROP);
        log.trace("LDAP Login Password: {}", (Object)(ldapLoginPassword == null ? null : "*****"));
        String ldapUserNameKey = directory.getValue(LDAP_USERNAME_PROP);
        log.trace("LDAP User Name Key: {}", (Object)ldapUserNameKey);
        String ldapFilter = directory.getValue(LDAP_USERFILTER_PROP);
        log.trace("LDAP Filter: {}", (Object)ldapFilter);
        if (StringUtils.isBlank((String)ldapUrl) || StringUtils.isBlank((String)ldapBaseDn)) {
            throw new ConfigurationException("Could not extract needed keys from this directory. Is probably not connecting to an LDAP.");
        }
        String userBase = ldapBaseDn;
        if (StringUtils.isNotBlank((String)ldapUserDn)) {
            userBase = ldapUserDn + "," + userBase;
        }
        LdapConnector connector = new LdapConnector();
        connector.setLdapUrl(ldapUrl);
        connector.setSsl(Boolean.parseBoolean(ldapSecure));
        connector.setUserBase(userBase);
        connector.setLoginUser(ldapLoginUser);
        connector.setLoginPassword(ldapLoginPassword);
        if (StringUtils.isNotBlank((String)ldapUserNameKey)) {
            connector.setUserNameKey(ldapUserNameKey);
        }
        if (StringUtils.isNotBlank((String)ldapFilter)) {
            connector.setFilter(ldapFilter);
        }
        return connector;
    }

    public void connect() throws NamingException {
        this.connect(null);
    }

    public void connect(Map<String, String> envMap) throws NamingException {
        this.disconnect();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        log.debug("Connecting to LDAP URL: {}", (Object)this.getLdapUrl());
        env.put("java.naming.provider.url", this.getLdapUrl());
        if (this.isSsl()) {
            log.debug("Using SSL for LDAP connection.");
            env.put("java.naming.security.protocol", "ssl");
        } else {
            log.debug("Not using SSL for LDAP connection.");
            env.put("java.naming.security.protocol", "none");
        }
        if (StringUtils.isBlank((String)this.getLoginUser()) || StringUtils.isBlank((String)this.getLoginPassword())) {
            log.debug("Using anonymous login for LDAP.");
            env.put("java.naming.security.authentication", "none");
        } else {
            log.debug("Using simple login for LDAP with user: {}", (Object)this.getLoginUser());
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.getLoginUser());
            env.put("java.naming.security.credentials", this.getLoginPassword());
        }
        log.trace("Using additional parameters: {}", envMap);
        if (envMap != null) {
            env.putAll(envMap);
        }
        this.setContext(new InitialDirContext(env));
    }

    public void disconnect() {
        this.setContext(null);
    }

    public DirContext getContext() {
        return this.context;
    }

    protected void setContext(DirContext context) {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.context = context;
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String loginUser) {
        this.loginUser = loginUser;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserNameKey() {
        return this.userNameKey;
    }

    public void setUserNameKey(String userNameKey) {
        this.userNameKey = userNameKey == null ? DEFAULT_USERNAME_KEY : userNameKey;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String toString() {
        return "LdapConnector [userNameKey=" + this.userNameKey + ", ldapUrl=" + this.ldapUrl + ", userBase=" + this.userBase + ", loginUser=" + this.getLoginUser() + ", loginPassword=" + (this.getLoginPassword() == null ? null : "*****") + "]";
    }
}

