/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeDecryptionKeyStoreLoader;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeDecryptionKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeDecryptionKeyManager
extends APrivateKeyManager<SnotifySmimeDecryptionKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeDecryptionKeyManager.class);

    public SmimeDecryptionKeyManager(ISnotifyAppProperties appProps) {
        super(null, appProps);
    }

    @Override
    protected List<Supplier<Optional<IKeyLoader<SnotifySmimeDecryptionKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimeDecryptionKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifySmimeDecryptionKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimeDecryptionKey>> createKeyStoreLoader() {
        KeyStore ks;
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No S/MIME key store configured to retrieve S/MIME private keys from.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        log.debug("Loading S/MIME key store from location: {}", (Object)location);
        try {
            ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            log.debug("Loaded S/MIME key store from location \"{}\" succesfully.", (Object)location);
        }
        catch (Exception e) {
            log.error("Could not load S/MIME key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new SmimeDecryptionKeyStoreLoader(ks, keyPassword));
    }

    @Override
    protected SnotifySmimeDecryptionKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifySmimeDecryptionKey(validity, keySource);
    }

    @Override
    protected Class<SnotifySmimeDecryptionKey> getCacheClass() {
        return SnotifySmimeDecryptionKey.class;
    }
}

