/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.sign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.protect.ProtectedHeadersMailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.sign.AMailSigner;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailSigner
extends AMailSigner<SnotifyPgpSignKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpMailSigner.class);
    private boolean includePublicKey;

    public PgpMailSigner(Session session, SnotifyPgpSignKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void sign(MimeMessage msg) throws IOException, MessagingException {
        log.debug("Signing message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        MimeMultipart signedMulti = new MimeMultipart("signed;\n\tprotocol=\"application/pgp-signature\";\n\tmicalg=\"pgp-sha256\"");
        BodyPart toSign = this.createContentPart(msg);
        if (this.isIncludePublicKey()) {
            BodyPart keyPart = this.createKeyPart();
            toSign = this.wrapContentAndKeys(toSign, keyPart);
        }
        signedMulti.addBodyPart(toSign);
        msg.setDisposition(null);
        msg.setContent((Multipart)signedMulti);
        msg.saveChanges();
        BodyPart signaturePart = this.createSignaturePart(toSign);
        signedMulti.addBodyPart(signaturePart);
        msg.saveChanges();
        log.debug("Successfully signed message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
    }

    private BodyPart createContentPart(MimeMessage msg) throws IOException, MessagingException {
        Object content = msg.getContent();
        String contentType = msg.getContentType();
        MimeBodyPart toSign = new MimeBodyPart();
        log.debug("Signing content of type: {}", (Object)contentType);
        toSign.setContent(content, contentType);
        MessageUtil.copyMatchingHeaders((Part)msg, (Part)toSign, Constants.STRUCTURAL_MIME_HEADERS);
        if (ProtectedHeadersMailHeaderProtector.isProtectedHeaders(contentType)) {
            MessageUtil.copyMatchingHeaders((Part)msg, (Part)toSign, Constants.USER_FACING_MIME_HEADERS);
        }
        return toSign;
    }

    private BodyPart wrapContentAndKeys(BodyPart contentPart, BodyPart keyPart) throws MessagingException {
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart(contentPart);
        mp.addBodyPart(keyPart);
        MimeBodyPart wrappedPart = new MimeBodyPart();
        wrappedPart.setContent((Multipart)mp);
        return wrappedPart;
    }

    private BodyPart createKeyPart() throws MessagingException, IOException {
        byte[] keyBytes;
        ArrayList publicKeys = new ArrayList();
        PGPSecretKeyRing secretRing = ((SnotifyPgpSignKey)this.getPrivateKey()).getKeyRing();
        secretRing.getPublicKeys().forEachRemaining(k -> publicKeys.add(k));
        PGPPublicKeyRing ring = new PGPPublicKeyRing(publicKeys);
        byte[] key = ring.getEncoded(true);
        try (ByteArrayInputStream is = new ByteArrayInputStream(ring.getEncoded(true));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream(3 * key.length);
            try (ArmoredOutputStream os = new ArmoredOutputStream(baos);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            keyBytes = baos.toByteArray();
        }
        MimeBodyPart keyPart = new MimeBodyPart();
        ByteArrayDataSource dsKey = new ByteArrayDataSource(keyBytes, "application/pgp-keys");
        keyPart.setDataHandler(new DataHandler((DataSource)dsKey));
        keyPart.setDescription("S/Notify PGP keys");
        keyPart.setDisposition("attachment; filename=\"key.asc\"");
        return keyPart;
    }

    private BodyPart createSignaturePart(BodyPart toSign) throws IOException, MessagingException {
        byte[] signedBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        toSign.writeTo((OutputStream)baos);
        log.debug("Signing message with key: {}", this.getPrivateKey());
        try {
            byte[] bytes = baos.toByteArray();
            PGPSecretKey key = ((SnotifyPgpSignKey)this.getPrivateKey()).getKey();
            char[] password = ((SnotifyPgpSignKey)this.getPrivateKey()).getPassword();
            int algorithm = 8;
            signedBytes = PgpUtil.sign(bytes, key, password, 8, true);
        }
        catch (PGPException e) {
            if ("checksum mismatch at 0 of 20".equals(e.getMessage())) {
                throw new MessagingException("Supplied password was wrong to extract private key.", (Exception)e);
            }
            throw new MessagingException(e.getLocalizedMessage(), (Exception)e);
        }
        MimeBodyPart signedPart = new MimeBodyPart();
        ByteArrayDataSource dsSigned = new ByteArrayDataSource(signedBytes, "application/pgp-signature");
        signedPart.setDataHandler(new DataHandler((DataSource)dsSigned));
        signedPart.setDescription("S/Notify PGP digital signature");
        signedPart.setDisposition("attachment; filename=\"signature.asc\"");
        return signedPart;
    }

    public boolean isIncludePublicKey() {
        return this.includePublicKey;
    }

    public void setIncludePublicKey(boolean includePublicKey) {
        this.includePublicKey = includePublicKey;
    }
}

