/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.sign.AMailSigner;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSet;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.Attribute;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaCertStore;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAttributeTableGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESignedGenerator;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailSigner
extends AMailSigner<SnotifySmimeSignKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailSigner.class);
    private boolean opaque;

    public SmimeMailSigner(Session session, SnotifySmimeSignKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void sign(MimeMessage msg) throws IOException, MessagingException {
        log.debug("Signing message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        SMIMESignedGenerator gen = this.prepareGenerator();
        if (this.isOpaque()) {
            this.signOpaque(msg, gen);
        } else {
            this.signNonOpaque(msg, gen);
        }
        log.debug("Successfully signed message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
    }

    private SMIMESignedGenerator prepareGenerator() throws MessagingException {
        JcaCertStore certStore;
        log.debug("Preparing S/MIME Signed generator.");
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        try {
            SignerInfoGenerator build = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(SecurityUtil.getProvider()).setSignedAttributeGenerator(this.createSignedAttrGenerator()).build("SHA1withRSA", ((SnotifySmimeSignKey)this.getPrivateKey()).getKey(), ((SnotifySmimeSignKey)this.getPrivateKey()).getPublicCert());
            gen.addSignerInfoGenerator(build);
        }
        catch (CertificateEncodingException e) {
            throw new MessagingException("Could not read certificate. Error message: " + e.getMessage(), (Exception)e);
        }
        catch (OperatorCreationException e) {
            throw new MessagingException("Failure creating signer information. Error message: " + e.getMessage(), (Exception)e);
        }
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        certChain.add(((SnotifySmimeSignKey)this.getPrivateKey()).getPublicCert());
        certChain.addAll(((SnotifySmimeSignKey)this.getPrivateKey()).getIntermediateCerts());
        try {
            certStore = new JcaCertStore(certChain);
        }
        catch (CertificateEncodingException e) {
            throw new MessagingException("Could not read certificate. Error message: " + e.getMessage(), (Exception)e);
        }
        gen.addCertificates(certStore);
        return gen;
    }

    private CMSAttributeTableGenerator createSignedAttrGenerator() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.createSmimeCapabilities());
        AttributeTable table = new AttributeTable(vector);
        DefaultSignedAttributeTableGenerator generator = new DefaultSignedAttributeTableGenerator(table);
        return generator;
    }

    private Attribute createSmimeCapabilities() {
        ArrayList<DLSequence> smimeCapas = new ArrayList<DLSequence>();
        smimeCapas.add(new DLSequence(NISTObjectIdentifiers.id_aes256_GCM));
        smimeCapas.add(new DLSequence(NISTObjectIdentifiers.id_aes256_CBC));
        smimeCapas.add(new DLSequence(PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305));
        smimeCapas.add(new DLSequence(NISTObjectIdentifiers.id_aes128_GCM));
        smimeCapas.add(new DLSequence(NISTObjectIdentifiers.id_aes128_CBC));
        DLSet set = new DLSet(new DLSequence(smimeCapas.toArray(new ASN1Encodable[smimeCapas.size()])));
        return new Attribute(PKCSObjectIdentifiers.pkcs_9_at_smimeCapabilities, set);
    }

    private void signNonOpaque(MimeMessage msg, SMIMESignedGenerator gen) throws IOException, MessagingException {
        MimeMultipart mm;
        log.debug("Signing message in a non-opaque way.");
        try {
            if (msg.getContent() instanceof MimeBodyPart || msg.getContent() instanceof MimeMultipart) {
                mm = gen.generate(msg);
            } else {
                MimeBodyPart part = new MimeBodyPart();
                part.setContent(msg.getContent(), msg.getContentType());
                mm = gen.generate(part);
            }
        }
        catch (SMIMEException e) {
            throw new MessagingException("Could not sign email. Error message: " + e.getMessage(), (Exception)e);
        }
        msg.setContent((Multipart)mm);
        msg.setDisposition(null);
        msg.saveChanges();
    }

    private void signOpaque(MimeMessage msg, SMIMESignedGenerator gen) throws MessagingException, IOException {
        MimeBodyPart signedPart;
        log.debug("Signing message in an opaque way.");
        try {
            signedPart = gen.generateEncapsulated(msg);
        }
        catch (SMIMEException e) {
            throw new MessagingException("Could not sign email. Error message: " + e.getMessage(), (Exception)e);
        }
        msg.setContent(signedPart.getContent(), signedPart.getContentType());
        MessageUtil.copyAllHeaders((Part)signedPart, (Part)msg);
        msg.saveChanges();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }
}

