/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Scanner;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    private static final String SNOTFY_IMG = "data:image/png;base64,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";
    private static final Logger log = LoggerFactory.getLogger(MessageBuilder.class);
    private final Message orgMsg;
    private final Session session;
    private URL additional;

    public MessageBuilder(Message orgMsg, Session session) {
        this.orgMsg = orgMsg;
        this.session = session;
        if (orgMsg == null) {
            throw new IllegalArgumentException("Original message must not be null.");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
    }

    public void additional(String file) {
        File additional = file == null ? null : new File(file);
        this.additional(additional);
    }

    public void additional(File file) {
        URL url = null;
        if (file != null) {
            if (file.canRead()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    log.error("Could not convert file to URL. Error message: " + e.getMessage(), (Throwable)e);
                }
            } else {
                log.error("Cannot read file: {}", (Object)file);
            }
        }
        this.additional(url);
    }

    public void additional(URL url) {
        this.additional = url;
    }

    public MimeMessage buildMail(String payload) throws MessagingException {
        String additional = this.getAdditional();
        SnotifyMimeMessage message = new SnotifyMimeMessage(this.session);
        Enumeration headers = this.orgMsg.getAllHeaders();
        log.trace("Copying headers from original message.");
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            message.addHeader(header.getName(), header.getValue());
            log.trace("{}: {}", (Object)header.getName(), (Object)header.getValue());
        }
        log.trace("Copying headers from original message finished.");
        StringBuilder builder = new StringBuilder(65536);
        builder.append("<html><body>");
        builder.append("<table style=\"width:100%\"><tr>");
        builder.append("<td><img alt=\"S/Notify image\" height=\"60\" width=\"60\" style=\"padding-right:15px\" src=\"");
        builder.append(SNOTFY_IMG);
        builder.append("\"></td><td>");
        builder.append(payload);
        if (additional != null) {
            builder.append(additional);
        }
        builder.append("</td></tr></table>");
        builder.append("</body></html>");
        message.setText(builder.toString(), "UTF-8", "html");
        message.saveChanges();
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAdditional() {
        if (this.additional == null) return null;
        log.debug("Loading additional content to add to message from: {}", (Object)this.additional);
        try (Scanner scanner = new Scanner(this.additional.openStream(), "UTF-8");){
            String text = scanner.useDelimiter("\\A").next();
            log.debug("Loaded additional content successfully.");
            log.trace("Loaded additional content: {}", (Object)text);
            String string = text;
            return string;
        }
        catch (IOException e) {
            log.error("Could not load additional content for report message. Error message: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

