/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.mailer.visitor.IMessageVisitor;

public class BaseMessageVisitor
implements IMessageVisitor {
    private boolean changed;

    public void visit(MimeMessage msg) throws Exception {
        this.setChanged(false);
        this.visit((MimePart)msg);
        if (this.isChanged()) {
            msg.saveChanges();
        }
    }

    @Override
    public void visit(MimeMultipart multi) throws Exception {
        int count = multi.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart part = multi.getBodyPart(i);
            if (!(part instanceof MimeBodyPart)) continue;
            this.visit((MimePart)((MimeBodyPart)part));
        }
    }

    @Override
    public void visit(MimePart part) throws Exception {
        Object content = part.getContent();
        if (content instanceof MimeMultipart) {
            this.visit((MimeMultipart)content);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }
}

