/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailPageExtractor
extends AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailPageExtractor.class);
    private PageManager pageManager;

    public ConfluenceMailPageExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        return this.getKeyDisplayVersion(url);
    }

    private String getKeyDisplayVersion(URL url) {
        String path = url.getPath();
        String indicator = "/display/";
        return this.getKey(path, "/display/");
    }

    private String getKey(String path, String indicator) {
        String pageTitle;
        String spaceId;
        int start;
        int end;
        int index = path.indexOf(indicator);
        if (index != -1 && (end = path.indexOf("/", start = index + indicator.length())) != -1 && !(spaceId = path.substring(start, end)).isEmpty() && spaceId.charAt(0) != '~' && !StringUtils.isEmpty((String)(pageTitle = path.substring(end + 1)))) {
            try {
                pageTitle = URLDecoder.decode(pageTitle, StandardCharsets.ISO_8859_1.name());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Page page = this.getPageManager().getPage(spaceId, pageTitle);
            if (page != null) {
                log.debug("Page with title {} has ID: {}", (Object)pageTitle, (Object)page.getIdAsString());
                return page.getIdAsString();
            }
            log.debug("Page with title {} does not belong to a page in space {}.", (Object)pageTitle, (Object)spaceId);
        }
        return null;
    }

    private PageManager getPageManager() {
        if (this.pageManager == null) {
            this.pageManager = (PageManager)ComponentLocator.getComponent(PageManager.class);
        }
        return this.pageManager;
    }
}

