/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.LMSHSSParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.LMSParameterSpec;

public class LMSKeyPairGeneratorSpi
extends KeyPairGenerator {
    private KeyGenerationParameters param;
    private ASN1ObjectIdentifier treeDigest;
    private AsymmetricCipherKeyPairGenerator engine = new LMSKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    public LMSKeyPairGeneratorSpi() {
        super("LMS");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof LMSParameterSpec) {
            LMSParameterSpec lmsParams = (LMSParameterSpec)params;
            this.param = new LMSKeyGenerationParameters(new LMSParameters(lmsParams.getSigParams(), lmsParams.getOtsParams()), random);
            this.engine = new LMSKeyPairGenerator();
            this.engine.init(this.param);
        } else if (params instanceof LMSHSSParameterSpec) {
            LMSParameterSpec[] lmsParams = ((LMSHSSParameterSpec)params).getLMSSpecs();
            LMSParameters[] hssParams = new LMSParameters[lmsParams.length];
            for (int i = 0; i != lmsParams.length; ++i) {
                hssParams[i] = new LMSParameters(lmsParams[i].getSigParams(), lmsParams[i].getOtsParams());
            }
            this.param = new HSSKeyGenerationParameters(hssParams, random);
            this.engine = new HSSKeyPairGenerator();
            this.engine.init(this.param);
        } else {
            throw new InvalidAlgorithmParameterException("parameter object not a LMSParameterSpec/LMSHSSParameterSpec");
        }
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new LMSKeyGenerationParameters(new LMSParameters(LMSigParameters.lms_sha256_n32_h10, LMOtsParameters.sha256_n32_w2), this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        if (this.engine instanceof LMSKeyPairGenerator) {
            LMSPublicKeyParameters pub = (LMSPublicKeyParameters)pair.getPublic();
            LMSPrivateKeyParameters priv = (LMSPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
        }
        HSSPublicKeyParameters pub = (HSSPublicKeyParameters)pair.getPublic();
        HSSPrivateKeyParameters priv = (HSSPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCLMSPublicKey(pub), new BCLMSPrivateKey(priv));
    }
}

