/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderEnforcer {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderEnforcer.class);
    private final Thread thread;
    private final ClassLoader threadLoader;
    private final ClassLoader enforcedLoader;
    private Exception exception;

    public ClassLoaderEnforcer(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Class Loader must not be null.");
        }
        this.thread = Thread.currentThread();
        this.threadLoader = this.thread.getContextClassLoader();
        this.enforcedLoader = loader;
    }

    public <T> void run(Consumer<T> consumer, T param) {
        if (ObjectUtils.equals((Object)this.threadLoader, (Object)this.enforcedLoader)) {
            log.trace("Thread's context class loader '{}' is identical to enforced class loader.", (Object)this.enforcedLoader);
            consumer.accept(param);
            return;
        }
        log.trace("Replacing thread's context class loader '{}' with enforced class loader '{}'.", (Object)this.threadLoader, (Object)this.enforcedLoader);
        try {
            this.thread.setContextClassLoader(this.enforcedLoader);
            consumer.accept(param);
        }
        finally {
            this.thread.setContextClassLoader(this.threadLoader);
            log.trace("Reset thread's context class loader.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void run(BiConsumer<T, U> consumer, T param1, U param2) {
        if (ObjectUtils.equals((Object)this.threadLoader, (Object)this.enforcedLoader)) {
            log.trace("Thread's context class loader '{}' is identical to enforced class loader.", (Object)this.enforcedLoader);
            consumer.accept(param1, param2);
            return;
        }
        log.trace("Replacing thread's context class loader '{}' with enforced class loader '{}'.", (Object)this.threadLoader, (Object)this.enforcedLoader);
        try {
            this.thread.setContextClassLoader(this.enforcedLoader);
            consumer.accept(param1, param2);
        }
        finally {
            this.thread.setContextClassLoader(this.threadLoader);
            log.trace("Reset thread's context class loader.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> R run(Function<T, R> function, T param) {
        if (ObjectUtils.equals((Object)this.threadLoader, (Object)this.enforcedLoader)) {
            log.trace("Thread's context class loader '{}' is identical to enforced class loader.", (Object)this.enforcedLoader);
            return function.apply(param);
        }
        log.trace("Replacing thread's context class loader '{}' with enforced class loader '{}'.", (Object)this.threadLoader, (Object)this.enforcedLoader);
        try {
            this.thread.setContextClassLoader(this.enforcedLoader);
            R r = function.apply(param);
            return r;
        }
        finally {
            this.thread.setContextClassLoader(this.threadLoader);
            log.trace("Reset thread's context class loader.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R run(BiFunction<T, U, R> function, T param1, U param2) {
        if (ObjectUtils.equals((Object)this.threadLoader, (Object)this.enforcedLoader)) {
            log.trace("Thread's context class loader '{}' is identical to enforced class loader.", (Object)this.enforcedLoader);
            return function.apply(param1, param2);
        }
        log.trace("Replacing thread's context class loader '{}' with enforced class loader '{}'.", (Object)this.threadLoader, (Object)this.enforcedLoader);
        try {
            this.thread.setContextClassLoader(this.enforcedLoader);
            R r = function.apply(param1, param2);
            return r;
        }
        finally {
            this.thread.setContextClassLoader(this.threadLoader);
            log.trace("Reset thread's context class loader.");
        }
    }

    public <T> T run(Supplier<T> supplier) {
        if (ObjectUtils.equals((Object)this.threadLoader, (Object)this.enforcedLoader)) {
            log.trace("Thread's context class loader '{}' is identical to enforced class loader.", (Object)this.enforcedLoader);
            return supplier.get();
        }
        log.trace("Replacing thread's context class loader '{}' with enforced class loader '{}'.", (Object)this.threadLoader, (Object)this.enforcedLoader);
        try {
            this.thread.setContextClassLoader(this.enforcedLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            this.thread.setContextClassLoader(this.threadLoader);
            log.trace("Reset thread's context class loader.");
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }
}

