/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access;

import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.info.InfoDataManager;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.ISnotifyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyLoader<T extends ISnotifyKey<?>>
implements IKeyLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(AKeyLoader.class);
    public static final int INFO_LOADED_KEY = 100;
    public static final int INFO_NULL_KEY = 101;
    public static final int INFO_ERROR = 102;
    private final InfoDataManager manager = new InfoDataManager();

    @Override
    public T loadKey() {
        T key = null;
        try {
            key = this.loadInternalKey();
        }
        catch (Exception e) {
            log.error("Could not load key. Error message: " + e.getMessage(), (Throwable)e);
            this.getInfoDataManager().send(new InfoData(102, e));
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.ERROR);
            this.getInfoDataManager().send(new InfoData(101, new Object[0]));
        }
        this.getInfoDataManager().send(new InfoData(100, key));
        return key;
    }

    protected abstract T loadInternalKey() throws Exception;

    protected abstract T getValidityKey(EKeyValidity var1);

    public InfoDataManager getInfoDataManager() {
        return this.manager;
    }
}

