/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpKeyServerLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpLdapLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpPublicKeyStoreLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.keysource.APublicKeyManager;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyManager
extends APublicKeyManager<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyManager.class);

    public PgpPublicKeyManager(String address, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(address, appProps, userProps);
        log.debug("PGP key manager for address: {}", (Object)address);
    }

    public PgpPublicKeyManager(IUser<?> user, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(user, EProperty.EMAIL_PGP_TIME_STAMP, appProps, userProps);
        log.debug("PGP key manager for user: {}", user);
    }

    @Override
    protected List<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>> getKeyLoaders() {
        ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>> loaders = new ArrayList<Supplier<Optional<IKeyLoader<SnotifyPgpPublicKey>>>>();
        loaders.add(this::createKeyStoreLoader);
        loaders.add(this::createKeyServerLoader);
        return loaders;
    }

    private Optional<IKeyLoader<SnotifyPgpPublicKey>> createKeyServerLoader() {
        ISnotifyAppProperties appProps = this.getAppProps();
        String keyServer = appProps.getString(EProperty.PUBLIC_KEYSERVER_PGP_LOCATION);
        if (keyServer == null) {
            log.debug("No PGP key server configured to retrieve PGP public keys from.");
            return Optional.empty();
        }
        log.debug("PGP key server configured: {}", (Object)keyServer);
        if (keyServer.startsWith("ldap")) {
            return this.createPgpLdapLoader(keyServer);
        }
        return this.createHkpKeyServerLoader(keyServer);
    }

    private Optional<IKeyLoader<SnotifyPgpPublicKey>> createPgpLdapLoader(String keyServer) {
        LdapConnector connector = new LdapConnector();
        connector.setLdapUrl(keyServer);
        connector.setSsl(keyServer.startsWith("ldaps"));
        return Optional.of(new PgpLdapLoader(connector, this.getAddress()));
    }

    private Optional<IKeyLoader<SnotifyPgpPublicKey>> createHkpKeyServerLoader(String keyServer) {
        ISnotifyAppProperties appProps = this.getAppProps();
        boolean encodeSearchParam = !appProps.getBoolean(EProperty.TWEAK_DO_NOT_ENCODE_PGP_SEARCH_PARAMETER);
        Long timeout = appProps.getLong(EProperty.TWEAK_URL_CONNECTION_TIMEOUT);
        PgpKeyServerLoader loader = new PgpKeyServerLoader(keyServer, this.getAddress());
        loader.setEncodeSearchParam(encodeSearchParam);
        if (timeout != null && timeout.intValue() >= 0) {
            loader.setTimeout(timeout.intValue());
        }
        return Optional.of(loader);
    }

    private Optional<IKeyLoader<SnotifyPgpPublicKey>> createKeyStoreLoader() {
        PGPPublicKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PUBLIC_KEYSTORE_PGP_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP public keys from.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadPublicKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpPublicKeyStoreLoader(keyRings, this.getAddress()));
    }

    @Override
    protected boolean isCachedKeyUsable(SnotifyPgpPublicKey key) {
        if (!super.isCachedKeyUsable(key)) {
            return false;
        }
        if (key.getKeySource() == EKeySource.USER && !this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE)) {
            log.debug("Cached key unusable: User key, but admin does not allow such keys.");
            return false;
        }
        return true;
    }

    @Override
    protected void setCachedKey(SnotifyPgpPublicKey key) throws IOException {
        IUser<?> user = this.getUser();
        ISnotifyUserProperties userProps = this.getUserProps();
        if (key == null) {
            log.debug("Clearing PGP key from user properties.");
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        } else {
            log.debug("Storing new PGP key to user properties: {}", (Object)key.getMasterKey());
            PGPPublicKey encryptionKey = key.getKey();
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, key.getEncoded(), user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, encryptionKey == null ? null : Long.valueOf(encryptionKey.getKeyID()), user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, key.getKeySource(), user);
        }
        userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
    }

    @Override
    protected SnotifyPgpPublicKey loadCachedPublicKey() {
        if (this.getUser() == null) {
            log.debug("No user given to retrieve PGP public keys from.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        PgpUserKeyLoader loader = new PgpUserKeyLoader(this.getUser(), this.getUserProps());
        return (SnotifyPgpPublicKey)loader.loadKey();
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifyPgpPublicKey(validity, keySource);
    }
}

