/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.encrypt.PgpMailEncryptor;
import net.savignano.snotify.atlassian.mailer.encrypt.SmimeMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpEncryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeEncryptionKeyManager;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import net.savignano.snotify.confluence.common.SnotifyI18n;
import net.savignano.snotify.confluence.mailer.ConfluenceMailPageExtractor;
import net.savignano.snotify.confluence.mailer.ConfluenceMailSpaceExtractor;
import net.savignano.snotify.confluence.mailer.keysource.smime.ConfluenceSmimeKeyManager;
import net.savignano.snotify.confluence.mailer.util.MessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailer
extends AAtlassianMailer<ConfluenceUser> {
    private static final String SNOTIFY_NAME = "S/Notify for Confluence";
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailer.class);
    private static final String PREFIX_REPLACEMENT = "%PREFIX%";
    private static final String SPACE_REPLACEMENT = "%SPACE%";

    public ConfluenceMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties spaceProps) {
        super(session, appProps, userProps, spaceProps);
    }

    @Override
    protected MimeMessage getFailureMessage(MessageAndAddress msgAndAddress, EKeyValidity validity) throws MessagingException {
        Locale locale;
        ConfluenceUser user = (ConfluenceUser)this.getUser(msgAndAddress.address);
        LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
        if (user != null) {
            log.debug("Getting locale for user: {}", (Object)user);
            locale = localeManager.getLocale(user.getActualUser());
        } else {
            log.debug("Getting default locale.");
            locale = localeManager.getSiteDefaultLocale();
        }
        log.debug("Used locale for address \"{}\": {}", (Object)msgAndAddress.address, (Object)locale);
        I18NBean i18nBean = ((I18NBeanFactory)ComponentLocator.getComponent(I18NBeanFactory.class)).getI18NBean(locale);
        SnotifyI18n i18n = new SnotifyI18n(i18nBean, locale);
        MessageBuilder builder = new MessageBuilder((Message)msgAndAddress.message, this.getSession(), i18n);
        builder.additional(this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT));
        if (validity == EKeyValidity.ERROR) {
            return builder.buildInternalErrorInfoMail();
        }
        EEncryptionTypePriority type = this.getTypePriority();
        builder.encryptionType(type);
        builder.editPgpInfo(this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        builder.editSmimeInfo(this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        return builder.buildMissingKeyInfoMail();
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Address toAddress, Address fromAddress) {
        ConfluenceUser user = (ConfluenceUser)this.getUser(toAddress);
        ConfluenceSmimeKeyManager manager = user == null ? new ConfluenceSmimeKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new ConfluenceSmimeKeyManager(user, this.getAppProps(), this.getUserProps());
        SmimeEncryptionKeyManager senderManager = new SmimeEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(this.getSession(), (SnotifySmimePublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        return encryptor;
    }

    protected PgpMailEncryptor getPgpEncryptor(Address toAddress, Address fromAddress) {
        ConfluenceUser user = (ConfluenceUser)this.getUser(toAddress);
        PgpPublicKeyManager manager = user == null ? new PgpPublicKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new PgpPublicKeyManager(user, this.getAppProps(), this.getUserProps());
        PgpEncryptionKeyManager senderManager = new PgpEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        PgpMailEncryptor encryptor = new PgpMailEncryptor(this.getSession(), (SnotifyPgpPublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        Long tweakAlgorithm = this.getAppProps().getLong(EProperty.TWEAK_PGP_SYMMETRIY_KEY_ALGORITHM);
        if (tweakAlgorithm != null) {
            encryptor.setForceSymmetricKeyAlgorithm(tweakAlgorithm.intValue());
        }
        return encryptor;
    }

    @Override
    protected List<String> extractProjectKeys(MimeMessage msg) {
        List<String> keys = this.extractSpaceKeys(msg);
        if (keys.size() <= 1) {
            return keys;
        }
        String subject = null;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            log.error("Could not get subject from email. Error message: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Looking for space and/or page references in subject: {}", (Object)subject);
        if (subject != null) {
            Space space = this.getSpaceFromSubject(subject, keys);
            if (space != null) {
                return Collections.singletonList(space.getKey());
            }
            keys = this.extractPageKeys(msg);
            Page page = this.getPageFromSubject(subject, keys);
            if (page != null) {
                return Collections.singletonList(page.getSpaceKey());
            }
        }
        return keys;
    }

    @Override
    protected List<ConfluenceUser> getUsers(Address address) {
        return ConfluenceUser.lookupUsers(address);
    }

    @Override
    protected boolean hasValidKey(ConfluenceUser user, ECryptographyType cryptography) {
        switch (cryptography) {
            case NONE: {
                return false;
            }
            case PGP: {
                return ((SnotifyPgpPublicKey)new PgpPublicKeyManager(user, this.getAppProps(), this.getUserProps()).getKey()).isValid();
            }
            case SMIME: {
                return ((SnotifySmimePublicKey)new ConfluenceSmimeKeyManager(user, this.getAppProps(), this.getUserProps()).getKey()).isValid();
            }
        }
        log.error("Unhandled cryptography: {}", (Object)cryptography);
        return false;
    }

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        ConfluenceUser user;
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        String whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        if (whitelistUserGroup != null && (user = (ConfluenceUser)this.getUser(msgAndAddress.address)) != null) {
            GroupManager manager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
            try {
                Group group = manager.getGroup(whitelistUserGroup);
                if (group != null) {
                    boolean member = manager.hasMembership(group, user.getActualUser());
                    log.debug("User {} is in group {}: {}", new Object[]{user, group, member});
                    return !member;
                }
                log.warn("Group {} does not exist.", (Object)whitelistUserGroup);
            }
            catch (EntityException e) {
                log.error("Could not check if user " + user + " is in group " + whitelistUserGroup + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    @Override
    protected String getSubjectReplacement(MimeMessage msg) {
        String replacement = super.getSubjectReplacement(msg);
        if (replacement != null && this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID)) {
            if (this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT) == null) {
                replacement = "%PREFIX% (%SPACE%) " + replacement;
            }
            log.debug("Subject replacement pattern: {}", (Object)replacement);
            replacement = this.replacePrefix(replacement);
            replacement = this.replaceSpace(msg, replacement);
            replacement = replacement.replace(" ()", "");
        }
        return replacement;
    }

    private String replacePrefix(String replacement) {
        int index = replacement.indexOf(PREFIX_REPLACEMENT);
        if (index == -1) {
            return replacement;
        }
        SMTPMailServer server = ((MailServerManager)ComponentLocator.getComponent(MailServerManager.class)).getDefaultSMTPMailServer();
        if (server == null) {
            log.error("No default SMTP server configured.");
            return replacement.replace(PREFIX_REPLACEMENT, "");
        }
        String prefix = server.getPrefix();
        log.debug("Used Prefix of default SMPT server: {}", (Object)prefix);
        return replacement.replace(PREFIX_REPLACEMENT, prefix == null ? "" : prefix);
    }

    private String replaceSpace(MimeMessage msg, String replacement) {
        if (replacement.indexOf(SPACE_REPLACEMENT) == -1) {
            return replacement;
        }
        List<String> keys = this.extractProjectKeys(msg);
        return replacement.replace(SPACE_REPLACEMENT, keys.size() == 1 ? (CharSequence)keys.get(0) : "");
    }

    private Space getSpaceFromSubject(String subject, Collection<String> keys) {
        if (!keys.isEmpty()) {
            SpaceManager spaceManager = (SpaceManager)ComponentLocator.getComponent(SpaceManager.class);
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                Space space = spaceManager.getSpace(key = iterator.next());
                log.trace("Space for key {}: {}", (Object)key, (Object)(space == null ? null : space.getDisplayTitle()));
                if (space == null || !subject.contains(space.getDisplayTitle())) continue;
                return space;
            }
        }
        return null;
    }

    private Page getPageFromSubject(String subject, Collection<String> keys) {
        if (!keys.isEmpty()) {
            PageManager pageManager = (PageManager)ComponentLocator.getComponent(PageManager.class);
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                Page page = pageManager.getPage(Long.valueOf(key = iterator.next()).longValue());
                log.trace("Page for key {}: {}", (Object)key, (Object)(page == null ? null : page.getDisplayTitle()));
                if (page == null || !subject.contains(page.getDisplayTitle())) continue;
                return page;
            }
        }
        return null;
    }

    private List<String> extractSpaceKeys(MimeMessage msg) {
        log.debug("Extracting space keys.");
        ConfluenceMailSpaceExtractor extractor = new ConfluenceMailSpaceExtractor(this.getBaseUrl());
        return this.extractKeys(msg, extractor);
    }

    private List<String> extractPageKeys(MimeMessage msg) {
        log.debug("Extracting page keys.");
        ConfluenceMailPageExtractor extractor = new ConfluenceMailPageExtractor(this.getBaseUrl());
        return this.extractKeys(msg, extractor);
    }

    private String getBaseUrl() {
        SettingsManager manager = (SettingsManager)ComponentLocator.getComponent(SettingsManager.class);
        return manager.getGlobalSettings().getBaseUrl();
    }

    private List<String> extractKeys(MimeMessage msg, AAtlassianMailKeyExtractor extractor) {
        Set<String> keys;
        String msgId = MessageUtil.getMessageId(msg);
        try {
            keys = extractor.getKeys(msg);
        }
        catch (Exception e) {
            log.error("Could not extract keys for email " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            keys = Collections.emptySet();
        }
        log.debug("Reference(s) found in email {}: {}", (Object)msgId, keys);
        return new ArrayList<String>(keys);
    }
}

