/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PBMParameter;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.PKMACValue;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.CRMFException;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.PKMACBuilder;
import net.savignano.thirdparty.org.bouncycastle.operator.MacCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.constantTimeAreEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

