/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.util;

import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.component.ComponentLocator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder
extends net.savignano.snotify.atlassian.mailer.util.MessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(MessageBuilder.class);
    public static String confluenceBaseUrl;
    private ISnotifyI18n i18n;
    private EEncryptionTypePriority encryptionType;
    private boolean editPgp;
    private boolean editSmime;

    private static final String getProfileUrl() {
        if (confluenceBaseUrl == null) {
            Settings globalSettings = ((SettingsManager)ComponentLocator.getComponent(SettingsManager.class)).getGlobalSettings();
            confluenceBaseUrl = globalSettings.getBaseUrl();
        }
        if (!confluenceBaseUrl.endsWith("/")) {
            confluenceBaseUrl = confluenceBaseUrl + "/";
        }
        log.trace("Base Confluence URL is: {}", (Object)confluenceBaseUrl);
        return confluenceBaseUrl + "users/snotify/snotify-user-settings-input.action";
    }

    public MessageBuilder(Message orgMsg, Session session) {
        this(orgMsg, session, null);
    }

    public MessageBuilder(Message orgMsg, Session session, ISnotifyI18n i18n) {
        super(orgMsg, session);
        this.i18n = i18n;
    }

    public void i18n(ISnotifyI18n i18n) {
        this.i18n = i18n;
    }

    public void encryptionType(EEncryptionTypePriority encryptionType) {
        this.encryptionType = encryptionType;
    }

    public void editPgpInfo(boolean edit) {
        this.editPgp = edit;
    }

    public void editSmimeInfo(boolean edit) {
        this.editSmime = edit;
    }

    public MimeMessage buildInternalErrorInfoMail() throws MessagingException {
        log.debug("Building info message for internal error.");
        StringBuilder builder = new StringBuilder(512);
        builder.append("<p>");
        builder.append(this.i18n.getText("snotify-mail.internalError.part1"));
        builder.append("</p>\n<p>");
        builder.append(this.i18n.getText("snotify-mail.internalError.part2"));
        builder.append("</p>");
        return this.buildMail(builder.toString());
    }

    public MimeMessage buildMissingKeyInfoMail() throws MessagingException {
        log.debug("Building info message for missing key.");
        StringBuilder builder = new StringBuilder(512);
        builder.append("<p><b>");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part1"));
        builder.append("</b></p>\n<p>");
        this.buildMissingKey(builder);
        builder.append("</p>");
        return this.buildMail(builder.toString());
    }

    private void buildMissingKey(StringBuilder builder) {
        if (this.encryptionType == null) {
            log.error("Encryption type not given.");
            this.buildMissingKeyNeitherBoth(builder);
            return;
        }
        switch (this.encryptionType) {
            case PGP_ONLY: {
                if (this.editPgp) {
                    this.buildMissingKeyPgp(builder);
                    break;
                }
                this.buildMissingKeyNeitherPgp(builder);
                break;
            }
            case PGP_PREFERED: 
            case SMIME_PREFERED: {
                if (this.editPgp || this.editSmime) {
                    if (!this.editSmime) {
                        this.buildMissingKeyPgp(builder);
                        break;
                    }
                    if (!this.editPgp) {
                        this.buildMissingKeySmime(builder);
                        break;
                    }
                    this.buildMissingKeyBoth(builder);
                    break;
                }
                this.buildMissingKeyNeitherBoth(builder);
                break;
            }
            case SMIME_ONLY: {
                if (this.editSmime) {
                    this.buildMissingKeySmime(builder);
                    break;
                }
                this.buildMissingKeyNeitherSmime(builder);
                break;
            }
            default: {
                log.error("Unknown encryption type encountered: {}", (Object)this.encryptionType);
                this.buildMissingKeyNeitherBoth(builder);
            }
        }
    }

    private void buildMissingKeyBoth(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.both"));
        builder.append(" <a href=\"");
        builder.append(MessageBuilder.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeyPgp(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.pgp"));
        builder.append(" <a href=\"");
        builder.append(MessageBuilder.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeySmime(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.smime"));
        builder.append(" <a href=\"");
        builder.append(MessageBuilder.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeyNeitherBoth(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.both"));
    }

    private void buildMissingKeyNeitherPgp(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.pgp"));
    }

    private void buildMissingKeyNeitherSmime(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.smime"));
    }
}

