/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeCertificateP7bLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.keysource.APublicKeyManager;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimePublicKeyManager
extends APublicKeyManager<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimePublicKeyManager.class);

    public SmimePublicKeyManager(String address, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(address, appProps, userProps);
        log.debug("S/MIME key manager for address: {}", (Object)address);
    }

    public SmimePublicKeyManager(IUser<?> user, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(user, EProperty.EMAIL_SMIME_TIME_STAMP, appProps, userProps);
        log.debug("S/MIME key manager for user: {}", user);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.EXTERNAL_LDAP, this::createExternalLdapLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createExternalLdapLoader() {
        String location = this.getAppProps().getString(EProperty.PUBLIC_LDAP_HOST_SMIME);
        if (location == null) {
            log.debug("No external LDAP for S/MIME specified. Can't get certificate from LDAP.");
            return Optional.empty();
        }
        LdapConnector connector = new LdapConnector();
        connector.setHost(location);
        connector.setPort(this.getAppProps().getLong(EProperty.PUBLIC_LDAP_PORT_SMIME).intValue());
        connector.setSsl(this.getAppProps().getBoolean(EProperty.PUBLIC_LDAP_SSL_SMIME));
        connector.setDn(this.getAppProps().getString(EProperty.PUBLIC_LDAP_DN_SMIME));
        connector.setFilter(this.getAppProps().getString(EProperty.PUBLIC_LDAP_FILTER_SMIME));
        connector.setLoginUser(this.getAppProps().getString(EProperty.PUBLIC_LDAP_LOGIN_USER_SMIME));
        connector.setLoginPassword(this.getAppProps().getPassword(EProperty.PUBLIC_LDAP_LOGIN_PASSWORD_SMIME));
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, "(mail=" + this.getAddress() + ")");
        loader.setEmail(this.getAddress());
        return Optional.of(loader);
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION);
        if (location == null) {
            log.debug("No key store specified. Can't get certificate from key store.");
            return Optional.empty();
        }
        String type = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_SMIME_TYPE);
        if (type == null) {
            log.debug("No key store type specified. Can't get certificate from key store.");
            return Optional.empty();
        }
        log.debug("Key store type: {}", (Object)type);
        switch (type) {
            case "BKS": {
                return this.createKeyStoreLoader(location, type);
            }
            case "PKCS7": {
                return this.createP7bStoreLoader(location);
            }
        }
        log.error("Could not load key store from location \"{}\". Unknown key store type encountered: {}", (Object)type);
        return Optional.empty();
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createKeyStoreLoader(String location, String type) {
        try {
            KeyStore ks = KeyStore.getInstance(type, SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, null);
            }
            log.debug("Loaded key store from location \"{}\" successfully.", (Object)location);
            return Optional.of(new SmimeCertificateKeyStoreLoader(ks, this.getAddress()));
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createP7bStoreLoader(String location) {
        CMSSignedData signature;
        log.debug("Loading P7B store from location: {}", (Object)location);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(location));){
            log.debug("Loaded P7B store from location \"{}\" successfully.", (Object)location);
            signature = new CMSSignedData(is);
        }
        catch (Exception e) {
            log.error("Could not load P7B store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new SmimeCertificateP7bLoader(signature.getCertificates(), this.getAddress()));
    }

    @Override
    protected boolean isCachedKeyUsable(SnotifySmimePublicKey key) {
        if (!super.isCachedKeyUsable(key)) {
            return false;
        }
        if (key.getKeySource() == EKeySource.USER && !this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE)) {
            log.debug("Cached key unusable: User key, but admin does not allow such keys.");
            return false;
        }
        return true;
    }

    @Override
    protected SnotifySmimePublicKey loadCachedPublicKey() {
        if (this.getUser() == null) {
            log.debug("No user given to retrieve S/MIME public keys from.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        SmimeUserKeyLoader loader = new SmimeUserKeyLoader(this.getUser(), this.getUserProps());
        return (SnotifySmimePublicKey)loader.loadKey();
    }

    @Override
    protected void setCachedKey(SnotifySmimePublicKey key) throws IOException {
        IUser<?> user = this.getUser();
        ISnotifyUserProperties userProps = this.getUserProps();
        if (key == null) {
            log.debug("Clearing S/MIME certificate from user properties.");
            userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
            userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        } else {
            log.debug("Storing new S/MIME certificate to user properties: {}", (Object)key.getKey());
            userProps.setBytes(EProperty.EMAIL_SMIME_CERT, key.getEncoded(), user);
            userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, key.getKeySource(), user);
        }
        userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SnotifySmimePublicKey(validity, keySource);
    }
}

