/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaqueSignatureConverter
extends BaseMessageVisitor {
    private static final Logger log = LoggerFactory.getLogger(OpaqueSignatureConverter.class);
    private String msgId;

    @Override
    public void visit(MimeMessage msg) throws Exception {
        this.msgId = MessageUtil.getMessageId(msg);
        log.debug("Looking for opaque signature in message with ID: {}", (Object)this.msgId);
        super.visit(msg);
        if (this.isChanged() && log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.trace("Final email:\n{}\n", (Object)baos.toString());
        }
        this.msgId = null;
    }

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType type = new ContentType(part.getContentType());
        log.trace("MIME type: {}", (Object)type);
        if ((type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) && "signed-data".equalsIgnoreCase(type.getParameter("smime-type"))) {
            log.debug("Found '{}' content. Converting opaque signature.", (Object)type);
            log.info("Converting opaque signature from message {} into clear signature.", (Object)this.msgId);
            SMIMESigned smimeSigned = new SMIMESigned((Part)part);
            MimeBodyPart contentPart = smimeSigned.getContent();
            MimeBodyPart signaturePart = new MimeBodyPart();
            signaturePart.setDisposition(part.getDisposition());
            signaturePart.setFileName(part.getFileName());
            signaturePart.setHeader("Content-Transfer-Encoding", part.getHeader("Content-Transfer-Encoding", null));
            ByteArrayDataSource ds = new ByteArrayDataSource(part.getInputStream(), part.getContentType());
            signaturePart.setDataHandler(new DataHandler((DataSource)ds));
            String protocol = type.getBaseType();
            MimeMultipart mp = new MimeMultipart("signed; protocol=\"" + protocol + "\"");
            mp.addBodyPart((BodyPart)contentPart);
            mp.addBodyPart((BodyPart)signaturePart);
            part.setDisposition(null);
            part.setContent((Multipart)mp);
            this.setChanged(true);
        }
    }
}

