/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexVisitor
extends BaseMessageVisitor {
    private static final Logger log = LoggerFactory.getLogger(RegexVisitor.class);
    private final Pattern pattern;
    private final List<MatchResult> matches = new ArrayList<MatchResult>();

    public RegexVisitor(Pattern pattern) {
        this.pattern = pattern;
        log.trace("Pattern used: {}", (Object)pattern.pattern());
    }

    @Override
    public void visit(MimePart part) throws Exception {
        log.trace("MimeType: {}", (Object)part.getContentType());
        if (part.isMimeType("text/*")) {
            log.trace("Found text content. Content transfer encoding: {}", (Object)part.getHeader("Content-Transfer-Encoding", null));
            Object content = part.getContent();
            if (content instanceof String) {
                this.checkForMatch((String)content);
            } else {
                log.warn("Expected content of type string, but was: {}", content == null ? null : content.getClass());
            }
        } else {
            super.visit(part);
        }
    }

    private void checkForMatch(String content) {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            log.trace("Found match: {}", (Object)matcher.group());
            this.matches.add(matcher.toMatchResult());
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.matches.clear();
    }

    public List<MatchResult> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }
}

