/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.keysource.smime;

import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.naming.ConfigurationException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimePublicKeyManager;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceSmimeKeyManager
extends SmimePublicKeyManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceSmimeKeyManager.class);

    public ConfluenceSmimeKeyManager(String address, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(address, appProps, userProps);
    }

    public ConfluenceSmimeKeyManager(ConfluenceUser user, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(user, appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> getKeyLoaders() {
        List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> loaders = super.getKeyLoaders();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.LDAP, this::createLdapLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createLdapLoader() {
        AtlassianLdapConnector connector;
        Directory directory;
        User user;
        if (!this.getAppProps().getBoolean(EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME)) {
            log.debug("Retrieving certificate from LDAP server is disabled.");
            return Optional.empty();
        }
        User user2 = user = this.getUser() == null ? null : this.getCrowdUser(((ConfluenceUser)this.getUser()).getActualUser());
        if (user == null) {
            log.debug("Could not find a crowd user for address: {}", (Object)this.getAddress());
            return Optional.empty();
        }
        long directoryId = user.getDirectoryId();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is not connecting to an LDAP.", (Object)directory.getName());
            return Optional.empty();
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP from directory " + directory.getName() + ". Error message: " + e.getMessage());
            return Optional.empty();
        }
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, userFilter);
        loader.setKeySource(EKeySource.LDAP);
        loader.setEmail(this.getAddress());
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        return Optional.of(loader);
    }

    private User getCrowdUser(com.atlassian.user.User user) {
        if (user instanceof User) {
            return (User)user;
        }
        if (user instanceof ConfluenceUserImpl) {
            return this.getCrowdUser(((ConfluenceUserImpl)user).getBackingUser());
        }
        return null;
    }
}

