/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeSignKeyStoreLoader
extends AKeyLoader<SnotifySmimeSignKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeSignKeyStoreLoader.class);
    private final KeyStore keyStore;
    private final String email;
    private final char[] password;

    public SmimeSignKeyStoreLoader(KeyStore keyStore, char[] password, String email) {
        this.keyStore = keyStore;
        this.email = email;
        this.password = password;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    @Override
    protected SnotifySmimeSignKey loadInternalKey() throws Exception {
        log.debug("Looking up private key for email: <{}>", (Object)this.getEmail());
        try {
            SnotifySmimeSignKey key = this.getValidKey();
            this.buildCertChain(key);
            return key;
        }
        catch (Exception e) {
            log.error("Could not load private key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    private SnotifySmimeSignKey getValidKey() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        X509Certificate cert = SmimeUtil.getValidCertForEmail(this.getKeyStore(), this.getEmail(), EKeyPurpose.SIGNING);
        if (cert == null) {
            log.info("Found no valid certificate for email <{}> in private key store.", (Object)this.getEmail());
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        PrivateKey privateKey = SmimeUtil.getPrivateKeyForCert(this.getKeyStore(), cert, this.password);
        if (privateKey == null) {
            String alias = this.getKeyStore().getCertificateAlias(cert);
            log.warn("Found a valid certificate for email <{}> in private key store, but not the corresponding private key. Please make sure that the private key for the certificate with serial number {} is stored in the key store at alias \"{}\".", new Object[]{this.getEmail(), SmimeUtil.getSerialNumber(cert), alias});
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Found valid signing key for <{}>.", (Object)this.getEmail());
        log.trace("Used private key: {}", (Object)privateKey);
        log.trace("Used certificate: {}", (Object)cert);
        SnotifySmimeSignKey snotifyKey = new SnotifySmimeSignKey(privateKey, cert, this.getEmail());
        snotifyKey.setKeySource(EKeySource.KEYSTORE);
        return snotifyKey;
    }

    private void buildCertChain(SnotifySmimeSignKey key) throws KeyStoreException {
        if (!key.isValid()) {
            return;
        }
        log.debug("Looking up intermediate certificates.");
        X509Certificate publicCert = key.getPublicCert();
        String alias = this.getKeyStore().getCertificateAlias(publicCert);
        Certificate[] chain = this.getKeyStore().getCertificateChain(alias);
        if (chain != null && chain.length > 1) {
            log.debug("Found {} intermediate certificate(s).", (Object)(chain.length - 2));
            for (int i = 1; i < chain.length - 1; ++i) {
                key.getIntermediateCerts().add((X509Certificate)chain[i]);
            }
            X509Certificate lastCert = (X509Certificate)chain[chain.length - 1];
            if (!lastCert.getSubjectX500Principal().equals(lastCert.getIssuerX500Principal())) {
                key.getIntermediateCerts().add(lastCert);
            }
            log.trace("Found intermediate certificates: {}", key.getIntermediateCerts());
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Listing all certificates in key store.");
            Enumeration<String> ksAliases = this.getKeyStore().aliases();
            while (ksAliases.hasMoreElements()) {
                String ksAlias = ksAliases.nextElement();
                X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(ksAlias);
                log.trace("Alias: {}; Subject: {}; Issuer: {}", new Object[]{ksAlias, certCandidate.getSubjectX500Principal(), certCandidate.getIssuerX500Principal()});
            }
        }
        log.debug("Fallback lookup of intermediate certificates.");
        X509Certificate cert = publicCert;
        while (cert != null) {
            if ((cert = this.getIssuerCert(cert)) == null) continue;
            key.getIntermediateCerts().add(cert);
        }
        log.trace("Found intermediate certificates: {}", key.getIntermediateCerts());
    }

    private X509Certificate getIssuerCert(X509Certificate cert) throws KeyStoreException {
        X500Principal issuerDN = cert.getIssuerX500Principal();
        if (issuerDN.equals(cert.getSubjectX500Principal())) {
            return null;
        }
        X509Certificate issuer = (X509Certificate)this.getKeyStore().getCertificate(issuerDN.getName());
        if (issuer != null) {
            return issuer;
        }
        Enumeration<String> aliases = this.getKeyStore().aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(alias);
            if (!certCandidate.getSubjectX500Principal().equals(issuerDN)) continue;
            return certCandidate;
        }
        return null;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SnotifySmimeSignKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimeSignKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "SmimePrivateKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****, email=" + this.email + "]";
    }
}

