/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.ALdapLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpLdapLoader
extends ALdapLoader<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpLdapLoader.class);
    private static final String PGP_KEY_ATTR = "pGPKey";

    public PgpLdapLoader(LdapConnector connector) {
        super(connector, null);
    }

    public PgpLdapLoader(LdapConnector connector, String userFilter) {
        super(connector, userFilter);
    }

    @Override
    protected SnotifyPgpPublicKey loadLdapKey() throws Exception {
        LdapConnector connector = this.getConnector();
        List<Attributes> attrs = this.getAttributes(connector.getContext(), connector.getDn(), connector.applyFilter(this.getUserFilter()), new String[]{PGP_KEY_ATTR});
        SnotifyPgpPublicKey key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        for (Attributes attributes : attrs) {
            SnotifyPgpPublicKey otherKey = this.getKey(attributes.get(PGP_KEY_ATTR));
            if (otherKey.compareTo(key) >= 0) continue;
            key = otherKey;
        }
        return key;
    }

    private SnotifyPgpPublicKey getKey(Attribute attribute) {
        String keyString;
        if (attribute == null || attribute.size() == 0) {
            log.debug("No data stored in {} attribute.", (Object)PGP_KEY_ATTR);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)PGP_KEY_ATTR);
        try {
            keyString = (String)attribute.get();
        }
        catch (NamingException e) {
            log.error("Could not read PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found PGP public key for {} in LDAP.", (Object)this.getUserFilter());
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(keyRing, this.getEmail());
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            log.error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }
}

