/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encrypt;

import java.io.IOException;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.IVersion;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.mailer.ISessionProvider;
import net.savignano.snotify.atlassian.mailer.encrypt.IMailEncryptor;

public abstract class AMailEncryptor<T extends ISnotifyPublicKey<?>>
implements IMailEncryptor<T>,
ISessionProvider {
    private final Session session;
    private final T publicKey;
    private T senderKey;
    private String hostName;
    private String snotifyName = "S/Notify";
    private IVersion version;

    public AMailEncryptor(Session session, T publicKey) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key must not be null.");
        }
        this.session = session;
        this.publicKey = publicKey;
        this.setHostName("<Unknown>");
    }

    @Override
    public void encryptMessage(MimeMessage msg) throws IOException, MessagingException {
        if (!this.getPublicKey().isValid()) {
            throw new MessagingException("Cannot encrypt message because of key having validity: " + (Object)((Object)this.getPublicKey().getKeyValidity()));
        }
        this.encrypt(msg);
    }

    protected abstract void encrypt(MimeMessage var1) throws IOException, MessagingException;

    @Override
    public T getPublicKey() {
        return this.publicKey;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getSnotifyName() {
        return this.snotifyName;
    }

    public void setSnotifyName(String snotifyName) {
        this.snotifyName = snotifyName;
    }

    public IVersion getVersion() {
        return this.version;
    }

    public void setVersion(IVersion version) {
        this.version = version;
    }

    public Optional<T> getSenderKey() {
        return Optional.ofNullable(this.senderKey);
    }

    public void setSenderPublicKey(T senderKey) {
        this.senderKey = senderKey;
    }
}

