/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.expose;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.expose.IMailHeaderExposer;
import net.savignano.snotify.atlassian.mailer.protect.ProtectedHeadersMailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;

public abstract class AMailHeaderExposer
extends BaseMessageVisitor
implements IMailHeaderExposer {
    private MimeMessage msg;

    @Override
    public void exposeHeaders(MimeMessage msg) throws MessagingException {
        this.msg = msg;
        try {
            this.visit(msg);
            if (this.isChanged()) {
                this.getLogger().info("Exposed protected headers for message with ID: {}", (Object)MessageUtil.getMessageId(msg));
            }
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage(), e);
        }
    }

    @Override
    public void visit(MimeMessage msg) throws Exception {
        if (msg.isMimeType("message/rfc822")) {
            this.unwrapHeaders(msg);
            this.setChanged(true);
        } else {
            super.visit(msg);
        }
    }

    private void unwrapHeaders(MimeMessage msg) throws IOException, MessagingException {
        this.getLogger().debug("Found RFC822 protected headers.");
        MimePart part = (MimePart)msg.getContent();
        msg.setContent(part.getContent(), part.getContentType());
        MessageUtil.copyAllHeaders((Part)part, (Part)msg);
        msg.saveChanges();
    }

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        if (part != this.getMessage() && ProtectedHeadersMailHeaderProtector.isProtectedHeaders((Part)part)) {
            this.getLogger().debug("Found protected headers.");
            MessageUtil.copyNonMatchingHeaders((Part)part, (Part)this.getMessage(), Constants.STRUCTURAL_MIME_HEADERS);
            this.setChanged(true);
        }
        if (part.isMimeType("multipart/mixed") && this.isLegacy((MimeMultipart)part.getContent())) {
            this.getLogger().debug("Found legacy part.");
            BodyPart contentPart = ((MimeMultipart)part.getContent()).getBodyPart(1);
            part.setContent(contentPart.getContent(), contentPart.getContentType());
            this.setChanged(true);
        }
    }

    private boolean isLegacy(MimeMultipart multi) throws MessagingException {
        BodyPart part0;
        ContentType type;
        if (multi.getCount() == 2 && ((type = new ContentType((part0 = multi.getBodyPart(0)).getContentType())).match("text/plain") || type.match("text/rfc822-headers"))) {
            return ProtectedHeadersMailHeaderProtector.isProtectedHeaders(type);
        }
        return false;
    }

    protected MimeMessage getMessage() {
        return this.msg;
    }
}

