/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.validate;

import java.util.Optional;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.enums.EValidationType;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.validate.IMailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMailValidator<T extends ISnotifyPublicKey<?>>
implements IMailValidator<T> {
    private static final Logger log = LoggerFactory.getLogger(AMailValidator.class);

    protected abstract T getValidityKey(EKeyValidity var1);

    @Override
    public boolean validateMessage(MimeMessage msg, Set<EValidationType> validations) {
        if (msg == null) {
            return false;
        }
        if (validations == null || validations.isEmpty()) {
            return true;
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return false;
        }
        if (!this.isSigned(msg)) {
            return false;
        }
        try {
            return this.validate(msg, validations, email.get());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected abstract boolean isSigned(MimeMessage var1);

    protected abstract boolean validate(MimeMessage var1, Set<EValidationType> var2, String var3) throws Exception;

    @Override
    public T extractPublicKey(MimeMessage msg) {
        T key;
        if (msg == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        try {
            key = this.extract(msg, email.get());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            key = this.getValidityKey(EKeyValidity.ERROR);
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return key;
    }

    protected abstract T extract(MimeMessage var1, String var2) throws Exception;
}

