/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.mailer.visitor.ContentTypeVisitor;

public class InlineSignatureConverter
extends ContentTypeVisitor {
    @Override
    protected boolean isRelevant(ContentType type) {
        return type.match("text/plain");
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        String content = (String)part.getContent();
        if (!content.startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
            return;
        }
        this.getLogger().info("Removing inline signature from message with ID: {}.", (Object)this.getMsgId());
        String text = this.getTextRemoveHeaders(content);
        ContentType contentType = new ContentType(part.getContentType());
        String charset = contentType.getParameter("charset");
        charset = charset == null ? "UTF-8" : charset;
        part.setText(text, charset);
    }

    private String getText(String fullContent) {
        int startIndex = "-----BEGIN PGP SIGNED MESSAGE-----".length();
        int endIndex = fullContent.indexOf("-----BEGIN PGP SIGNATURE-----");
        String cropped = fullContent.substring(startIndex, endIndex);
        return this.removeLinebreaks(cropped);
    }

    private String getTextRemoveHeaders(String fullContent) throws MessagingException, IOException {
        StringBuilder builder = new StringBuilder(fullContent.length());
        ContentType contentType = new ContentType("text/plain");
        contentType.setParameter("charset", "UTF-8");
        builder.append("Content-Type");
        builder.append(": ");
        builder.append(contentType.toString());
        builder.append("\r\n");
        builder.append(this.getText(fullContent));
        MimeBodyPart part = new MimeBodyPart((InputStream)new ByteArrayInputStream(builder.toString().getBytes(Constants.UTF8_CHARSET)));
        return (String)part.getContent();
    }

    private String removeLinebreaks(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int start = str.startsWith("\r\n") ? 2 : (str.charAt(0) == '\r' || str.charAt(0) == '\n' ? 1 : 0);
        int end = str.endsWith("\r\n") ? str.length() - 2 : (str.charAt(str.length() - 1) == '\r' || str.charAt(str.length() - 1) == '\n' ? str.length() - 1 : str.length());
        return str.substring(start, end);
    }
}

