/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.visitor.ContentTypeVisitor;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;

public class SignatureRemover
extends ContentTypeVisitor {
    @Override
    protected boolean isRelevant(ContentType type) {
        return type.match("multipart/signed") || (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) && "signed-data".equalsIgnoreCase(type.getParameter("smime-type"));
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        if (part.isMimeType("multipart/signed")) {
            this.getLogger().debug("Found '{}' content. Removing signature.", (Object)part.getContentType());
            this.getLogger().info("Removing signature from message {}.", (Object)this.getMsgId());
            Multipart mp = (Multipart)part.getContent();
            BodyPart contentPart = mp.getBodyPart(0);
            this.removeSignature((MimeBodyPart)contentPart, part);
        } else {
            this.getLogger().debug("Found '{}' content. Removing opaque signature.", (Object)part.getContentType());
            this.getLogger().info("Removing signature from message {}.", (Object)this.getMsgId());
            SMIMESigned smimeSigned = new SMIMESigned((Part)part);
            MimeBodyPart content = smimeSigned.getContent();
            this.removeSignature(content, part);
        }
    }

    private void removeSignature(MimeBodyPart contentPart, MimePart parentPart) throws MessagingException, IOException {
        parentPart.setDisposition(null);
        parentPart.removeHeader("Content-Transfer-Encoding");
        parentPart.setContent(contentPart.getContent(), contentPart.getContentType());
        MessageUtil.copyAllHeaders((Part)contentPart, (Part)parentPart);
        this.setChanged(true);
    }
}

