/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.util;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import net.savignano.snotify.confluence.mailer.ConfluenceMailPageTitleExtractor;
import net.savignano.snotify.confluence.mailer.ConfluenceMailPageUrlExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder
extends net.savignano.snotify.atlassian.mailer.util.MessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(MessageBuilder.class);
    private final ISnotifyI18n i18n;
    private final String baseUrl;
    private final MimeMessage orgMsg;
    private EEncryptionTypePriority encryptionType;
    private boolean editPgp;
    private boolean editSmime;
    private boolean showLink;

    public MessageBuilder(MimeMessage orgMsg, Session session, ISnotifyI18n i18n) {
        this(orgMsg, session, i18n, ((SettingsManager)ComponentLocator.getComponent(SettingsManager.class)).getGlobalSettings().getBaseUrl());
    }

    public MessageBuilder(MimeMessage orgMsg, Session session, ISnotifyI18n i18n, String baseUrl) {
        super((Message)orgMsg, session);
        this.orgMsg = orgMsg;
        this.i18n = i18n;
        this.baseUrl = baseUrl;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null");
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException("BaseUrl must not be null");
        }
    }

    public void encryptionType(EEncryptionTypePriority encryptionType) {
        this.encryptionType = encryptionType;
    }

    public void editPgpInfo(boolean edit) {
        this.editPgp = edit;
    }

    public void editSmimeInfo(boolean edit) {
        this.editSmime = edit;
    }

    public void showLink(boolean showLink) {
        this.showLink = showLink;
    }

    public MimeMessage buildInternalErrorInfoMail() throws MessagingException {
        log.debug("Building info message for internal error.");
        StringBuilder builder = new StringBuilder(512);
        builder.append("<p>");
        builder.append(this.i18n.getText("snotify-mail.internalError.part1"));
        builder.append("</p>\n<p>");
        builder.append(this.i18n.getText("snotify-mail.internalError.part2"));
        builder.append("</p>");
        if (this.showLink) {
            try {
                this.computeLink();
            }
            catch (MessagingException e) {
                log.error("Failure comuting page link. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.buildMail(builder.toString());
    }

    public MimeMessage buildMissingKeyInfoMail() throws MessagingException {
        log.debug("Building info message for missing key.");
        StringBuilder builder = new StringBuilder(512);
        builder.append("<p><b>");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part1"));
        builder.append("</b></p>\n<p>");
        this.buildMissingKey(builder);
        builder.append("</p>");
        if (this.showLink) {
            try {
                this.computeLink();
            }
            catch (MessagingException e) {
                log.error("Failure comuting page link. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.buildMail(builder.toString());
    }

    private void buildMissingKey(StringBuilder builder) {
        if (this.encryptionType == null) {
            log.error("Encryption type not given.");
            this.buildMissingKeyNeitherBoth(builder);
            return;
        }
        switch (this.encryptionType) {
            case PGP_ONLY: {
                if (this.editPgp) {
                    this.buildMissingKeyPgp(builder);
                    break;
                }
                this.buildMissingKeyNeitherPgp(builder);
                break;
            }
            case PGP_PREFERED: 
            case SMIME_PREFERED: {
                if (this.editPgp || this.editSmime) {
                    if (!this.editSmime) {
                        this.buildMissingKeyPgp(builder);
                        break;
                    }
                    if (!this.editPgp) {
                        this.buildMissingKeySmime(builder);
                        break;
                    }
                    this.buildMissingKeyBoth(builder);
                    break;
                }
                this.buildMissingKeyNeitherBoth(builder);
                break;
            }
            case SMIME_ONLY: {
                if (this.editSmime) {
                    this.buildMissingKeySmime(builder);
                    break;
                }
                this.buildMissingKeyNeitherSmime(builder);
                break;
            }
            default: {
                log.error("Unknown encryption type encountered: {}", (Object)this.encryptionType);
                this.buildMissingKeyNeitherBoth(builder);
            }
        }
    }

    private void buildMissingKeyBoth(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.both"));
        builder.append(" <a href=\"");
        builder.append(this.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeyPgp(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.pgp"));
        builder.append(" <a href=\"");
        builder.append(this.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeySmime(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.smime"));
        builder.append(" <a href=\"");
        builder.append(this.getProfileUrl());
        builder.append("\">");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.profile"));
        builder.append("</a> ");
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.admin"));
    }

    private void buildMissingKeyNeitherBoth(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.both"));
    }

    private void buildMissingKeyNeitherPgp(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.pgp"));
    }

    private void buildMissingKeyNeitherSmime(StringBuilder builder) {
        builder.append(this.i18n.getText("snotify-mail.missingKey.part2.neither.smime"));
    }

    private final String getProfileUrl() {
        return this.baseUrl + "/users/snotify/snotify-user-settings-input.action";
    }

    private void computeLink() throws MessagingException {
        Set<String> urls;
        Set<String> titles;
        AAtlassianMailKeyExtractor titleExtractor = this.getTitleExtractor(this.baseUrl);
        try {
            titles = titleExtractor.getKeys(this.orgMsg);
            if (titles.size() == 1) {
                AAtlassianMailKeyExtractor urlExtractor = this.getUrlExtractor(this.baseUrl);
                urls = urlExtractor.getKeys(this.orgMsg);
            } else {
                urls = Collections.emptySet();
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
        if (!urls.isEmpty()) {
            String title = titles.iterator().next();
            String url = this.extractUrl(urls, titleExtractor);
            this.sourceLink(url);
            this.sourceText(this.i18n.getText("snotify-mail.link", (Object)title));
        }
    }

    private String extractUrl(Set<String> urls, AAtlassianMailKeyExtractor titleExtractor) {
        if (urls.size() == 1) {
            return urls.iterator().next();
        }
        for (String url : urls) {
            Set<String> match = titleExtractor.getKeys(url);
            if (match.isEmpty()) continue;
            return url;
        }
        return null;
    }

    private AAtlassianMailKeyExtractor getTitleExtractor(String baseUrl) {
        return new ConfluenceMailPageTitleExtractor(baseUrl);
    }

    private AAtlassianMailKeyExtractor getUrlExtractor(String baseUrl) {
        ConfluenceMailPageUrlExtractor extractor = new ConfluenceMailPageUrlExtractor(baseUrl);
        extractor.setRemoveQueryFragment(true);
        return extractor;
    }
}

