/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.apache.bzip2.BZip2Constants;
import net.savignano.thirdparty.org.bouncycastle.apache.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    private boolean finished;
    int count;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private byte[] blockBytes = null;
    private short[] quadrantShorts = null;
    private int[] zptr = null;
    private int[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentByte = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private final int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    private static void panic() {
        throw new IllegalStateException();
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    protected static void hbMakeCodeLengths(byte[] len, int[] freq, int alphaSize, int maxLen) {
        int i;
        int[] heap = new int[260];
        int[] weight = new int[516];
        int[] parent = new int[516];
        for (i = 0; i < alphaSize; ++i) {
            weight[i + 1] = (freq[i] == 0 ? 1 : freq[i]) << 8;
        }
        block1: while (true) {
            int j;
            int tmp;
            int zz;
            int nNodes = alphaSize;
            int nHeap = 0;
            heap[0] = 0;
            weight[0] = 0;
            parent[0] = -2;
            for (i = 1; i <= alphaSize; ++i) {
                parent[i] = -1;
                heap[++nHeap] = i;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nHeap >= 260) {
                CBZip2OutputStream.panic();
            }
            while (nHeap > 1) {
                int n1 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                int yy = 0;
                int tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                int n2 = heap[1];
                heap[1] = heap[nHeap];
                --nHeap;
                zz = 0;
                yy = 0;
                tmp2 = 0;
                zz = 1;
                tmp2 = heap[zz];
                while ((yy = zz << 1) <= nHeap) {
                    if (yy < nHeap && weight[heap[yy + 1]] < weight[heap[yy]]) {
                        ++yy;
                    }
                    if (weight[tmp2] < weight[heap[yy]]) break;
                    heap[zz] = heap[yy];
                    zz = yy;
                }
                heap[zz] = tmp2;
                parent[n1] = parent[n2] = ++nNodes;
                weight[nNodes] = (weight[n1] & 0xFFFFFF00) + (weight[n2] & 0xFFFFFF00) | 1 + ((weight[n1] & 0xFF) > (weight[n2] & 0xFF) ? weight[n1] & 0xFF : weight[n2] & 0xFF);
                parent[nNodes] = -1;
                heap[++nHeap] = nNodes;
                zz = 0;
                tmp = 0;
                zz = nHeap;
                tmp = heap[zz];
                while (weight[tmp] < weight[heap[zz >> 1]]) {
                    heap[zz] = heap[zz >> 1];
                    zz >>= 1;
                }
                heap[zz] = tmp;
            }
            if (nNodes >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean tooLong = false;
            for (i = 1; i <= alphaSize; ++i) {
                j = 0;
                int k = i;
                while (parent[k] >= 0) {
                    k = parent[k];
                    ++j;
                }
                len[i - 1] = (byte)j;
                if (j <= maxLen) continue;
                tooLong = true;
            }
            if (!tooLong) break;
            i = 1;
            while (true) {
                if (i >= alphaSize) continue block1;
                j = weight[i] >> 8;
                j = 1 + j / 2;
                weight[i] = j << 8;
                ++i;
            }
            break;
        }
    }

    public CBZip2OutputStream(OutputStream outStream) throws IOException {
        this(outStream, 9);
    }

    public CBZip2OutputStream(OutputStream outStream, int blockSize) throws IOException {
        outStream.write(66);
        outStream.write(90);
        this.bsSetStream(outStream);
        this.workFactor = 50;
        if (blockSize > 9) {
            blockSize = 9;
        }
        if (blockSize < 1) {
            blockSize = 1;
        }
        this.blockSize100k = blockSize;
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    public void write(int bv) throws IOException {
        int b = bv & 0xFF;
        if (this.currentByte == b) {
            ++this.runLength;
            if (this.runLength > 254) {
                this.writeRun();
                this.currentByte = -1;
                this.runLength = 0;
            }
        } else if (this.currentByte == -1) {
            this.currentByte = b;
            ++this.runLength;
        } else {
            this.writeRun();
            this.runLength = 1;
            this.currentByte = b;
        }
    }

    private void writeRun() throws IOException {
        if (this.count > this.allowableBlockSize) {
            this.endBlock();
            this.initBlock();
        }
        this.inUse[this.currentByte] = true;
        for (int i = 0; i < this.runLength; ++i) {
            this.mCrc.updateCRC(this.currentByte);
        }
        switch (this.runLength) {
            case 1: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 2: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 3: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            default: {
                this.inUse[this.runLength - 4] = true;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)(this.runLength - 4);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentByte = -1;
        if (this.count > 0) {
            this.endBlock();
        }
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.count = 0;
        for (int i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        this.bsW(1, this.blockRandomised ? 1 : 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private void hbAssignCodes(int[] code, byte[] length, int minLen, int maxLen, int alphaSize) {
        int vec = 0;
        for (int n = minLen; n <= maxLen; ++n) {
            for (int i = 0; i < alphaSize; ++i) {
                if ((length[i] & 0xFF) != n) continue;
                code[i] = vec++;
            }
            vec <<= 1;
        }
    }

    private void bsSetStream(OutputStream f) {
        this.bsStream = f;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsW(int n, int v) throws IOException {
        while (this.bsLive >= 8) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
        this.bsBuff |= v << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void bsPutUChar(int c) throws IOException {
        this.bsW(8, c);
    }

    private void bsPutint(int u) throws IOException {
        this.bsW(8, u >> 24 & 0xFF);
        this.bsW(8, u >> 16 & 0xFF);
        this.bsW(8, u >> 8 & 0xFF);
        this.bsW(8, u & 0xFF);
    }

    private void bsPutIntVS(int numBits, int c) throws IOException {
        this.bsW(numBits, c);
    }

    private void sendMTFValues() throws IOException {
        int i16;
        int j;
        int i;
        int ge;
        int v;
        int t;
        byte[][] len = new byte[6][258];
        int nSelectors = 0;
        int alphaSize = this.nInUse + 2;
        for (t = 0; t < 6; ++t) {
            byte[] len_t = len[t];
            for (v = 0; v < alphaSize; ++v) {
                len_t[v] = 15;
            }
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int nGroups = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int nPart = nGroups;
        int remF = this.nMTF;
        int gs = 0;
        while (nPart > 0) {
            int aFreq;
            int tFreq = remF / nPart;
            ge = gs - 1;
            for (aFreq = 0; aFreq < tFreq && ge < alphaSize - 1; aFreq += this.mtfFreq[++ge]) {
            }
            if (ge > gs && nPart != nGroups && nPart != 1 && (nGroups - nPart) % 2 == 1) {
                aFreq -= this.mtfFreq[ge];
                --ge;
            }
            byte[] len_np = len[nPart - 1];
            for (v = 0; v < alphaSize; ++v) {
                len_np[v] = v >= gs && v <= ge ? 0 : 15;
            }
            --nPart;
            gs = ge + 1;
            remF -= aFreq;
        }
        int[][] rfreq = new int[6][258];
        int[] fave = new int[6];
        short[] cost = new short[6];
        byte[] len_0 = len[0];
        byte[] len_1 = len[1];
        byte[] len_2 = len[2];
        byte[] len_3 = len[3];
        byte[] len_4 = len[4];
        byte[] len_5 = len[5];
        for (int iter = 0; iter < 4; ++iter) {
            for (t = 0; t < nGroups; ++t) {
                fave[t] = 0;
                int[] rfreq_t = rfreq[t];
                for (v = 0; v < alphaSize; ++v) {
                    rfreq_t[v] = 0;
                }
            }
            nSelectors = 0;
            gs = 0;
            while (gs < this.nMTF) {
                ge = Math.min(gs + 50 - 1, this.nMTF - 1);
                if (nGroups == 6) {
                    short cost0 = 0;
                    short cost1 = 0;
                    short cost2 = 0;
                    short cost3 = 0;
                    short cost4 = 0;
                    short cost5 = 0;
                    for (i = gs; i <= ge; ++i) {
                        int icv = this.szptr[i];
                        cost0 = (short)(cost0 + (len_0[icv] & 0xFF));
                        cost1 = (short)(cost1 + (len_1[icv] & 0xFF));
                        cost2 = (short)(cost2 + (len_2[icv] & 0xFF));
                        cost3 = (short)(cost3 + (len_3[icv] & 0xFF));
                        cost4 = (short)(cost4 + (len_4[icv] & 0xFF));
                        cost5 = (short)(cost5 + (len_5[icv] & 0xFF));
                    }
                    cost[0] = cost0;
                    cost[1] = cost1;
                    cost[2] = cost2;
                    cost[3] = cost3;
                    cost[4] = cost4;
                    cost[5] = cost5;
                } else {
                    for (t = 0; t < nGroups; ++t) {
                        cost[t] = 0;
                    }
                    for (i = gs; i <= ge; ++i) {
                        int icv = this.szptr[i];
                        for (t = 0; t < nGroups; ++t) {
                            int n = t;
                            cost[n] = (short)(cost[n] + (len[t][icv] & 0xFF));
                        }
                    }
                }
                short s = 999999999;
                int bt = -1;
                for (t = 0; t < nGroups; ++t) {
                    if (cost[t] >= s) continue;
                    s = cost[t];
                    bt = t;
                }
                int n = bt;
                fave[n] = fave[n] + 1;
                this.selector[nSelectors] = (char)bt;
                ++nSelectors;
                int[] rfreq_bt = rfreq[bt];
                for (i = gs; i <= ge; ++i) {
                    int n2 = this.szptr[i];
                    rfreq_bt[n2] = rfreq_bt[n2] + 1;
                }
                gs = ge + 1;
            }
            for (t = 0; t < nGroups; ++t) {
                CBZip2OutputStream.hbMakeCodeLengths(len[t], rfreq[t], alphaSize, 20);
            }
        }
        rfreq = null;
        fave = null;
        cost = null;
        if (nGroups >= 8) {
            CBZip2OutputStream.panic();
        }
        if (nSelectors >= 32768 || nSelectors > 18002) {
            CBZip2OutputStream.panic();
        }
        char[] pos = new char[6];
        for (i = 0; i < nGroups; ++i) {
            pos[i] = (char)i;
        }
        for (i = 0; i < nSelectors; ++i) {
            char ll_i = this.selector[i];
            j = 0;
            char tmp = pos[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = pos[++j];
                pos[j] = tmp2;
            }
            pos[0] = tmp;
            this.selectorMtf[i] = (char)j;
        }
        int[][] code = new int[6][258];
        for (t = 0; t < nGroups; ++t) {
            int minLen = 32;
            int maxLen = 0;
            byte[] len_t = len[t];
            for (i = 0; i < alphaSize; ++i) {
                int lti = len_t[i] & 0xFF;
                if (lti > maxLen) {
                    maxLen = lti;
                }
                if (lti >= minLen) continue;
                minLen = lti;
            }
            if (maxLen > 20) {
                CBZip2OutputStream.panic();
            }
            if (minLen < 1) {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(code[t], len[t], minLen, maxLen, alphaSize);
        }
        boolean[] inUse16 = new boolean[16];
        block21: for (i = 0; i < 16; ++i) {
            inUse16[i] = false;
            i16 = i * 16;
            for (j = 0; j < 16; ++j) {
                if (!this.inUse[i16 + j]) continue;
                inUse16[i] = true;
                continue block21;
            }
        }
        for (i = 0; i < 16; ++i) {
            this.bsW(1, inUse16[i] ? 1 : 0);
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            i16 = i * 16;
            for (j = 0; j < 16; ++j) {
                this.bsW(1, this.inUse[i16 + j] ? 1 : 0);
            }
        }
        this.bsW(3, nGroups);
        this.bsW(15, nSelectors);
        for (i = 0; i < nSelectors; ++i) {
            int count;
            for (count = this.selectorMtf[i]; count >= 24; count -= 24) {
                this.bsW(24, 0xFFFFFF);
            }
            this.bsW(count + '\u0001', (1 << count + 1) - 2);
        }
        for (t = 0; t < nGroups; ++t) {
            byte[] len_t = len[t];
            int curr = len_t[0] & 0xFF;
            this.bsW(5, curr);
            for (i = 0; i < alphaSize; ++i) {
                int lti = len_t[i] & 0xFF;
                while (curr < lti) {
                    this.bsW(2, 2);
                    ++curr;
                }
                while (curr > lti) {
                    this.bsW(2, 3);
                    --curr;
                }
                this.bsW(1, 0);
            }
        }
        int selCtr = 0;
        gs = 0;
        while (gs < this.nMTF) {
            ge = Math.min(gs + 50 - 1, this.nMTF - 1);
            char selector_selCtr = this.selector[selCtr];
            byte[] len_selCtr = len[selector_selCtr];
            int[] code_selCtr = code[selector_selCtr];
            for (i = gs; i <= ge; ++i) {
                int sfmap_i = this.szptr[i];
                this.bsW(len_selCtr[sfmap_i] & 0xFF, code_selCtr[sfmap_i]);
            }
            gs = ge + 1;
            ++selCtr;
        }
        if (selCtr != nSelectors) {
            CBZip2OutputStream.panic();
        }
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void simpleSort(int lo, int hi, int d) {
        int bigN = hi - lo + 1;
        if (bigN < 2) {
            return;
        }
        int hp = 0;
        while (this.incs[hp] < bigN) {
            ++hp;
        }
        --hp;
        while (hp >= 0) {
            int h = this.incs[hp];
            for (int i = lo + h; i <= hi; ++i) {
                int v = this.zptr[i];
                int j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (++i > hi) break;
                v = this.zptr[i];
                j = i;
                while (this.fullGtU(this.zptr[j - h] + d, v + d)) {
                    this.zptr[j] = this.zptr[j - h];
                    if ((j -= h) > lo + h - 1) continue;
                }
                this.zptr[j] = v;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --hp;
        }
    }

    private void vswap(int p1, int p2, int n) {
        while (--n >= 0) {
            int t1 = this.zptr[p1];
            int t2 = this.zptr[p2];
            this.zptr[p1++] = t2;
            this.zptr[p2++] = t1;
        }
    }

    private int med3(int a, int b, int c) {
        return a > b ? (c < b ? b : (c > a ? a : c)) : (c < a ? a : (c > b ? b : c));
    }

    private static void pushStackElem(Vector stack, int stackCount, int ll, int hh, int dd) {
        StackElem stackElem;
        if (stackCount < stack.size()) {
            stackElem = (StackElem)stack.elementAt(stackCount);
        } else {
            stackElem = new StackElem();
            stack.addElement(stackElem);
        }
        stackElem.ll = ll;
        stackElem.hh = hh;
        stackElem.dd = dd;
    }

    private void qSort3(int loSt, int hiSt, int dSt) {
        Vector stack = new Vector();
        int stackCount = 0;
        int lo = loSt;
        int hi = hiSt;
        int d = dSt;
        while (true) {
            int n;
            int gtHi;
            int ltLo;
            if (hi - lo < 20 || d > 10) {
                this.simpleSort(lo, hi, d);
                if (stackCount < 1 || this.workDone > this.workLimit && this.firstAttempt) {
                    return;
                }
                StackElem stackElem = (StackElem)stack.elementAt(--stackCount);
                lo = stackElem.ll;
                hi = stackElem.hh;
                d = stackElem.dd;
                continue;
            }
            int d1 = d + 1;
            int med = this.med3(this.blockBytes[this.zptr[lo] + d1] & 0xFF, this.blockBytes[this.zptr[hi] + d1] & 0xFF, this.blockBytes[this.zptr[lo + hi >>> 1] + d1] & 0xFF);
            int unLo = ltLo = lo;
            int unHi = gtHi = hi;
            while (true) {
                int zUnHi;
                int zUnLo;
                if (unLo <= unHi && (n = (this.blockBytes[(zUnLo = this.zptr[unLo]) + d1] & 0xFF) - med) <= 0) {
                    if (n == 0) {
                        this.zptr[unLo] = this.zptr[ltLo];
                        this.zptr[ltLo++] = zUnLo;
                    }
                    ++unLo;
                    continue;
                }
                while (unLo <= unHi && (n = (this.blockBytes[(zUnHi = this.zptr[unHi]) + d1] & 0xFF) - med) >= 0) {
                    if (n == 0) {
                        this.zptr[unHi] = this.zptr[gtHi];
                        this.zptr[gtHi--] = zUnHi;
                    }
                    --unHi;
                }
                if (unLo > unHi) break;
                int temp = this.zptr[unLo];
                this.zptr[unLo++] = this.zptr[unHi];
                this.zptr[unHi--] = temp;
            }
            if (gtHi < ltLo) {
                d = d1;
                continue;
            }
            n = Math.min(ltLo - lo, unLo - ltLo);
            this.vswap(lo, unLo - n, n);
            int m = Math.min(hi - gtHi, gtHi - unHi);
            this.vswap(unLo, hi - m + 1, m);
            n = lo + (unLo - ltLo);
            m = hi - (gtHi - unHi);
            CBZip2OutputStream.pushStackElem(stack, stackCount++, lo, n - 1, d);
            CBZip2OutputStream.pushStackElem(stack, stackCount++, n, m, d1);
            lo = m + 1;
        }
    }

    private void mainSort() {
        int i;
        int[] runningOrder = new int[256];
        int[] copy = new int[256];
        boolean[] bigDone = new boolean[256];
        for (i = 0; i < 20; ++i) {
            this.blockBytes[this.count + i + 1] = this.blockBytes[i % this.count + 1];
        }
        for (i = 0; i <= this.count + 20; ++i) {
            this.quadrantShorts[i] = 0;
        }
        this.blockBytes[0] = this.blockBytes[this.count];
        if (this.count <= 4000) {
            for (i = 0; i < this.count; ++i) {
                this.zptr[i] = i;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.count - 1, 0);
        } else {
            int j;
            int c2;
            for (i = 0; i <= 255; ++i) {
                bigDone[i] = false;
            }
            for (i = 0; i <= 65536; ++i) {
                this.ftab[i] = 0;
            }
            int c1 = this.blockBytes[0] & 0xFF;
            for (i = 0; i < this.count; ++i) {
                c2 = this.blockBytes[i + 1] & 0xFF;
                int n = (c1 << 8) + c2;
                this.ftab[n] = this.ftab[n] + 1;
                c1 = c2;
            }
            for (i = 1; i <= 65536; ++i) {
                int n = i;
                this.ftab[n] = this.ftab[n] + this.ftab[i - 1];
            }
            c1 = this.blockBytes[1] & 0xFF;
            i = 0;
            while (i < this.count - 1) {
                c2 = this.blockBytes[i + 2] & 0xFF;
                j = (c1 << 8) + c2;
                c1 = c2;
                int n = j;
                this.ftab[n] = this.ftab[n] - 1;
                this.zptr[this.ftab[j]] = i++;
            }
            int n = j = ((this.blockBytes[this.count] & 0xFF) << 8) + (this.blockBytes[1] & 0xFF);
            this.ftab[n] = this.ftab[n] - 1;
            this.zptr[this.ftab[j]] = this.count - 1;
            for (i = 0; i <= 255; ++i) {
                runningOrder[i] = i;
            }
            int h = 1;
            while ((h = 3 * h + 1) <= 256) {
            }
            do {
                for (i = h /= 3; i <= 255; ++i) {
                    int vv = runningOrder[i];
                    j = i;
                    while (this.ftab[runningOrder[j - h] + 1 << 8] - this.ftab[runningOrder[j - h] << 8] > this.ftab[vv + 1 << 8] - this.ftab[vv << 8]) {
                        runningOrder[j] = runningOrder[j - h];
                        if ((j -= h) > h - 1) continue;
                    }
                    runningOrder[j] = vv;
                }
            } while (h != 1);
            for (i = 0; i <= 255; ++i) {
                int ss = runningOrder[i];
                for (j = 0; j <= 255; ++j) {
                    int sb = (ss << 8) + j;
                    if ((this.ftab[sb] & 0x200000) == 0x200000) continue;
                    int hi = (this.ftab[sb + 1] & 0xFFDFFFFF) - 1;
                    int lo = this.ftab[sb] & 0xFFDFFFFF;
                    if (hi > lo) {
                        this.qSort3(lo, hi, 2);
                        if (this.workDone > this.workLimit && this.firstAttempt) {
                            return;
                        }
                    }
                    int n2 = sb;
                    this.ftab[n2] = this.ftab[n2] | 0x200000;
                }
                bigDone[ss] = true;
                if (i < 255) {
                    int bbStart = this.ftab[ss << 8] & 0xFFDFFFFF;
                    int bbSize = (this.ftab[ss + 1 << 8] & 0xFFDFFFFF) - bbStart;
                    int shifts = 0;
                    while (bbSize >> shifts > 65534) {
                        ++shifts;
                    }
                    for (j = 0; j < bbSize; ++j) {
                        short qVal;
                        int a2update = this.zptr[bbStart + j] + 1;
                        this.quadrantShorts[a2update] = qVal = (short)(j >> shifts);
                        if (a2update > 20) continue;
                        this.quadrantShorts[a2update + this.count] = qVal;
                    }
                    if (bbSize - 1 >> shifts > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                for (j = 0; j <= 255; ++j) {
                    copy[j] = this.ftab[(j << 8) + ss] & 0xFFDFFFFF;
                }
                for (j = this.ftab[ss << 8] & 0xFFDFFFFF; j < (this.ftab[ss + 1 << 8] & 0xFFDFFFFF); ++j) {
                    c1 = this.blockBytes[this.zptr[j]] & 0xFF;
                    if (bigDone[c1]) continue;
                    this.zptr[copy[c1]] = (this.zptr[j] == 0 ? this.count : this.zptr[j]) - 1;
                    int n3 = c1;
                    copy[n3] = copy[n3] + 1;
                }
                for (j = 0; j <= 255; ++j) {
                    int n4 = (j << 8) + ss;
                    this.ftab[n4] = this.ftab[n4] | 0x200000;
                }
            }
        }
    }

    private void randomiseBlock() {
        int i;
        int rNToGo = 0;
        int rTPos = 0;
        for (i = 0; i < 256; ++i) {
            this.inUse[i] = false;
        }
        for (i = 0; i < this.count; ++i) {
            if (rNToGo == 0) {
                rNToGo = (char)rNums[rTPos];
                if (++rTPos == 512) {
                    rTPos = 0;
                }
            }
            int n = i + 1;
            this.blockBytes[n] = (byte)(this.blockBytes[n] ^ (--rNToGo == 1 ? (byte)1 : 0));
            this.inUse[this.blockBytes[i + 1] & 0xFF] = true;
        }
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * (this.count - 1);
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        for (int i = 0; i < this.count; ++i) {
            if (this.zptr[i] != 0) continue;
            this.origPtr = i;
            break;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private boolean fullGtU(int i1, int i2) {
        int c2;
        int c1;
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
            return c1 > c2;
        }
        int k = this.count;
        do {
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            int s1 = this.quadrantShorts[i1] & 0xFFFF;
            int s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if ((c1 = this.blockBytes[++i1] & 0xFF) != (c2 = this.blockBytes[++i2] & 0xFF)) {
                return c1 > c2;
            }
            s1 = this.quadrantShorts[i1] & 0xFFFF;
            s2 = this.quadrantShorts[i2] & 0xFFFF;
            if (s1 != s2) {
                return s1 > s2;
            }
            if (i1 >= this.count) {
                i1 -= this.count;
            }
            if (i2 >= this.count) {
                i2 -= this.count;
            }
            ++this.workDone;
        } while ((k -= 4) >= 0);
        return false;
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.blockBytes = new byte[n + 1 + 20];
        this.quadrantShorts = new short[n + 1 + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        this.szptr = this.zptr;
    }

    private void generateMTFValues() {
        int i;
        char[] yy = new char[256];
        this.makeMaps();
        int EOB = this.nInUse + 1;
        for (i = 0; i <= EOB; ++i) {
            this.mtfFreq[i] = 0;
        }
        int wr = 0;
        int zPend = 0;
        for (i = 0; i < this.nInUse; ++i) {
            yy[i] = (char)i;
        }
        for (i = 0; i < this.count; ++i) {
            char ll_i = this.unseqToSeq[this.blockBytes[this.zptr[i]] & 0xFF];
            int j = 0;
            char tmp = yy[j];
            while (ll_i != tmp) {
                char tmp2 = tmp;
                tmp = yy[++j];
                yy[j] = tmp2;
            }
            yy[0] = tmp;
            if (j == 0) {
                ++zPend;
                continue;
            }
            if (zPend > 0) {
                --zPend;
                while (true) {
                    switch (zPend % 2) {
                        case 0: {
                            this.szptr[wr++] = 0;
                            this.mtfFreq[0] = this.mtfFreq[0] + 1;
                            break;
                        }
                        case 1: {
                            this.szptr[wr++] = 1;
                            this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        }
                    }
                    if (zPend < 2) break;
                    zPend = (zPend - 2) / 2;
                }
                zPend = 0;
            }
            this.szptr[wr++] = j + 1;
            int n = j + 1;
            this.mtfFreq[n] = this.mtfFreq[n] + 1;
        }
        if (zPend > 0) {
            --zPend;
            while (true) {
                switch (zPend % 2) {
                    case 0: {
                        this.szptr[wr++] = 0;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[wr++] = 1;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (zPend < 2) break;
                zPend = (zPend - 2) / 2;
            }
        }
        this.szptr[wr++] = EOB;
        int n = EOB;
        this.mtfFreq[n] = this.mtfFreq[n] + 1;
        this.nMTF = wr;
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        private StackElem() {
        }
    }
}

