/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERGeneralizedTime;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCFailInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCStatus;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCStatusInfoV2;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCStatusInfoV2Builder;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.ExtendedFailInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.PendInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class CMCStatusInfoV2Test
extends SimpleTest {
    public static void main(String[] args) {
        CMCStatusInfoV2Test.runTest(new CMCStatusInfoV2Test());
    }

    public String getName() {
        return "CMCStatusInfoV2Test";
    }

    public void performTest() throws Exception {
        CMCStatusInfoV2Builder bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L));
        CMCStatusInfoV2 cmsInfo = bldr.build();
        this.isTrue("Has statusString", null == cmsInfo.getStatusStringUTF8());
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        byte[] b = cmsInfo.getEncoded();
        CMCStatusInfoV2 res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats");
        cmsInfo = bldr.build();
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new PendInfo(Strings.toByteArray("fish"), new DERGeneralizedTime(new Date())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, cmsInfo.getOtherStatusInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: PendInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, res.getOtherStatusInfo().isFailInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(CMCFailInfo.authDataFail);
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is fail info", true, cmsInfo.getOtherStatusInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: CMCFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is fail info", true, res.getOtherStatusInfo().isFailInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new ExtendedFailInfo(PKCSObjectIdentifiers.bagtypes, new DEROctetString("fish".getBytes())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is extended fail info", true, cmsInfo.getOtherStatusInfo().isExtendedFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: ExtendedFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is extended fail info", true, res.getOtherStatusInfo().isExtendedFailInfo());
    }
}

