/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.DecryptedPOP;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class DecryptedPOPTest
extends SimpleTest {
    public static void main(String[] args) {
        DecryptedPOPTest.runTest(new DecryptedPOPTest());
    }

    public String getName() {
        return "DecryptedPOPTest";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.9.8.7.6"));
        DecryptedPOP pop = new DecryptedPOP(new BodyPartID(10L), algId, "cats".getBytes());
        byte[] b = pop.getEncoded();
        DecryptedPOP popResult = DecryptedPOP.getInstance(b);
        this.isEquals("Bodypart id", popResult.getBodyPartID(), pop.getBodyPartID());
        this.isTrue("The POP", Arrays.areEqual(popResult.getThePOP(), pop.getThePOP()));
        this.isEquals("POP Result", popResult.getThePOPAlgID(), pop.getThePOPAlgID());
        try {
            DecryptedPOP.getInstance(new DERSequence(new BodyPartID(10L)));
            this.fail("Sequence must be 3 elements long");
        }
        catch (Throwable t) {
            this.isEquals(t.getClass(), IllegalArgumentException.class);
        }
    }
}

