/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.LraPopWitness;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class LraPopWitnessTest
extends SimpleTest {
    public static void main(String[] args) {
        LraPopWitnessTest.runTest(new LraPopWitnessTest());
    }

    public String getName() {
        return "LraPopWitnessTest";
    }

    public void performTest() throws Exception {
        LraPopWitness popWitness = new LraPopWitness(new BodyPartID(10L), new DERSequence(new ASN1Integer(20L)));
        byte[] b = popWitness.getEncoded();
        LraPopWitness popWitnessResult = LraPopWitness.getInstance(b);
        this.isTrue("BodyIds", Arrays.areEqual(popWitness.getBodyIds(), popWitnessResult.getBodyIds()));
        this.isEquals("PkiDataBody", popWitness.getPkiDataBodyid(), popWitnessResult.getPkiDataBodyid());
        try {
            LraPopWitness.getInstance(new DERSequence());
            this.fail("Sequence length must be 2");
        }
        catch (Throwable t) {
            this.isEquals("Exception class", t.getClass(), IllegalArgumentException.class);
        }
    }
}

