/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1GeneralizedTime;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCFailInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.ExtendedFailInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.OtherStatusInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.PendInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class OtherStatusInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        OtherStatusInfoTest.runTest(new OtherStatusInfoTest());
    }

    public String getName() {
        return "OtherStatusInfoTest";
    }

    public void performTest() throws Exception {
        OtherStatusInfo ose = OtherStatusInfo.getInstance(CMCFailInfo.badCertId.toASN1Primitive());
        byte[] b = ose.getEncoded();
        OtherStatusInfo oseResult = OtherStatusInfo.getInstance(b);
        this.isEquals("isFailInfo", oseResult.isFailInfo(), true);
        this.isEquals("isPendInfo", oseResult.isPendingInfo(), false);
        this.isEquals("isExtendedFailInfo", oseResult.isExtendedFailInfo(), false);
        this.isEquals(ose, oseResult);
        ose = OtherStatusInfo.getInstance(new PendInfo("Fish".getBytes(), new ASN1GeneralizedTime(new Date())));
        b = ose.getEncoded();
        oseResult = OtherStatusInfo.getInstance(b);
        this.isEquals("isFailInfo", oseResult.isFailInfo(), false);
        this.isEquals("isPendInfo", oseResult.isPendingInfo(), true);
        this.isEquals("isExtendedFailInfo", oseResult.isExtendedFailInfo(), false);
        this.isEquals(ose, oseResult);
        ose = OtherStatusInfo.getInstance(new ExtendedFailInfo(PKCSObjectIdentifiers.canNotDecryptAny, new ASN1Integer(10L)));
        b = ose.getEncoded();
        oseResult = OtherStatusInfo.getInstance(b);
        this.isEquals("isFailInfo", oseResult.isFailInfo(), false);
        this.isEquals("isPendInfo", oseResult.isPendingInfo(), false);
        this.isEquals("isExtendedFailInfo", oseResult.isExtendedFailInfo(), true);
        this.isEquals(ose, oseResult);
    }
}

