/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERIA5String;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSet;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.CMCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.TaggedAttribute;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class TaggedAttributeTest
extends SimpleTest {
    public String getName() {
        return "TaggedAttributeTest";
    }

    public void performTest() throws Exception {
        DERSequence seq;
        TaggedAttribute ta = new TaggedAttribute(new BodyPartID(10L), CMCObjectIdentifiers.id_cct_PKIData, new DERSet(new DERIA5String("Cats")));
        byte[] d = ta.getEncoded();
        TaggedAttribute res1 = TaggedAttribute.getInstance(d);
        this.isEquals(ta.getBodyPartID(), res1.getBodyPartID());
        this.isEquals(ta.getAttrType(), res1.getAttrType());
        this.isEquals(ta.getAttrValues().getObjectAt(0), res1.getAttrValues().getObjectAt(0));
        this.isTrue(Arrays.areEqual(res1.getEncoded(), d));
        try {
            seq = new DERSequence(new ASN1Encodable[]{new BodyPartID(10L)});
            TaggedAttribute.getInstance(seq);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("incorrect sequence size", e.getMessage());
        }
        try {
            seq = new DERSequence(new ASN1Encodable[]{ta.getBodyPartID(), ta.getAttrType(), ta.getAttrValues(), new ASN1Integer(0L)});
            TaggedAttribute.getInstance(seq);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("incorrect sequence size", e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        TaggedAttributeTest.runTest(new TaggedAttributeTest());
    }
}

