/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificateBuilder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Certificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateBase;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.VerificationKeyIndicator;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ITSImplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final IssuerIdentifier issuerIdentifier;

    public ITSImplicitCertificateBuilder(ITSCertificate issuer, DigestCalculatorProvider digestCalculatorProvider, ToBeSignedCertificate.Builder tbsCertificate) {
        super(issuer, tbsCertificate);
        DigestCalculator calculator;
        AlgorithmIdentifier digestAlgId = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        ASN1ObjectIdentifier digestAlg = digestAlgId.getAlgorithm();
        try {
            calculator = digestCalculatorProvider.get(digestAlgId);
        }
        catch (OperatorCreationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        try {
            OutputStream os = calculator.getOutputStream();
            os.write(issuer.getEncoded());
            os.close();
        }
        catch (IOException ioex) {
            throw new IllegalStateException(ioex.getMessage(), ioex);
        }
        byte[] parentDigest = calculator.getDigest();
        IssuerIdentifier.Builder issuerIdentifierBuilder = IssuerIdentifier.builder();
        HashedId.HashedId8 hashedID = new HashedId.HashedId8(Arrays.copyOfRange(parentDigest, parentDigest.length - 8, parentDigest.length));
        if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
            issuerIdentifierBuilder.sha256AndDigest(hashedID);
        } else if (digestAlg.equals(NISTObjectIdentifiers.id_sha384)) {
            issuerIdentifierBuilder.sha384AndDigest(hashedID);
        } else {
            throw new IllegalStateException("unknown digest");
        }
        this.issuerIdentifier = issuerIdentifierBuilder.createIssuerIdentifier();
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger x, BigInteger y) {
        return this.build(certificateId, x, y, null);
    }

    public ITSCertificate build(CertificateId certificateId, BigInteger x, BigInteger y, PublicEncryptionKey publicEncryptionKey) {
        EccP256CurvePoint reconstructionValue = EccP256CurvePoint.builder().createUncompressedP256(x, y);
        ToBeSignedCertificate.Builder tbsBldr = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        tbsBldr.setCertificateId(certificateId);
        if (publicEncryptionKey != null) {
            tbsBldr.setEncryptionKey(publicEncryptionKey);
        }
        tbsBldr.setVerificationKeyIndicator(VerificationKeyIndicator.builder().reconstructionValue(reconstructionValue).createVerificationKeyIndicator());
        CertificateBase.Builder baseBldr = new CertificateBase.Builder();
        baseBldr.setVersion(this.version);
        baseBldr.setType(CertificateType.Implicit);
        baseBldr.setIssuer(this.issuerIdentifier);
        baseBldr.setToBeSignedCertificate(tbsBldr.createToBeSignedCertificate());
        Certificate.Builder bldr = new Certificate.Builder();
        bldr.setCertificateBase(baseBldr.createCertificateBase());
        return new ITSCertificate(bldr.createCertificate());
    }
}

