/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jsse.provider;

import java.util.Set;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.CipherSuiteInfo;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.JcaAlgorithmDecomposer;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import net.savignano.thirdparty.org.bouncycastle.tls.CipherSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvAlgorithmDecomposer
extends JcaAlgorithmDecomposer {
    static final ProvAlgorithmDecomposer INSTANCE_TLS = new ProvAlgorithmDecomposer(true);
    static final ProvAlgorithmDecomposer INSTANCE_X509 = new ProvAlgorithmDecomposer(false);
    private final boolean enableTLSAlgorithms;

    private ProvAlgorithmDecomposer(boolean enableTLSAlgorithms) {
        this.enableTLSAlgorithms = enableTLSAlgorithms;
    }

    @Override
    public Set<String> decompose(String algorithm) {
        CipherSuiteInfo cipherSuiteInfo;
        if (algorithm.startsWith("TLS_") && null != (cipherSuiteInfo = ProvSSLContextSpi.getCipherSuiteInfo(algorithm)) && !CipherSuite.isSCSV(cipherSuiteInfo.getCipherSuite())) {
            return this.enableTLSAlgorithms ? cipherSuiteInfo.getDecompositionTLS() : cipherSuiteInfo.getDecompositionX509();
        }
        return super.decompose(algorithm);
    }
}

