/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HeaderInfoContributorId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class EtsiOriginatingHeaderInfoExtension
extends ASN1Object {
    private final HeaderInfoContributorId etsiHeaderInfoContributorId;
    private final ASN1OctetString extension;

    public EtsiOriginatingHeaderInfoExtension(HeaderInfoContributorId etsiHeaderInfoContributorId, ASN1OctetString extension) {
        this.etsiHeaderInfoContributorId = etsiHeaderInfoContributorId;
        this.extension = extension;
    }

    public static EtsiOriginatingHeaderInfoExtension getInstance(Object src) {
        if (src instanceof EtsiOriginatingHeaderInfoExtension) {
            return (EtsiOriginatingHeaderInfoExtension)src;
        }
        Iterator<ASN1Encodable> items = ASN1Sequence.getInstance(src).iterator();
        HeaderInfoContributorId id = HeaderInfoContributorId.getInstance(items.next());
        if (items.hasNext()) {
            return new EtsiOriginatingHeaderInfoExtension(id, ASN1OctetString.getInstance(items.next()));
        }
        return new EtsiOriginatingHeaderInfoExtension(id, null);
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.etsiHeaderInfoContributorId, this.extension);
    }

    public HeaderInfoContributorId getEtsiHeaderInfoContributorId() {
        return this.etsiHeaderInfoContributorId;
    }

    public ASN1OctetString getExtension() {
        return this.extension;
    }
}

