/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;

public class HashedData
extends ASN1Object
implements ASN1Choice {
    public static final int sha256HashedData = 0;
    public static final int extension = 1;
    public static final int sha384HashedData = 2;
    public static final int reserved = 3;
    private final int choice;
    private final ASN1Encodable value;

    public HashedData(int choice, ASN1Encodable sha256HashedData) {
        this.choice = choice;
        this.value = sha256HashedData;
    }

    public static HashedData getInstance(Object o) {
        if (o instanceof HashedData) {
            return (HashedData)o;
        }
        ASN1TaggedObject dto = ASN1TaggedObject.getInstance(o);
        switch (dto.getTagNo()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new HashedData(dto.getTagNo(), DEROctetString.getInstance(dto.getObject()));
            }
        }
        throw new IllegalStateException("unknown choice value " + dto.getTagNo());
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setSha256HashedData(ASN1Encodable sha256HashedData) {
            this.value = sha256HashedData;
            return this;
        }

        public Builder extension(byte[] extension) {
            this.value = new DEROctetString(extension);
            return this;
        }

        public Builder sha384HashedData(ASN1OctetString sha384HashedData) {
            this.value = sha384HashedData;
            return this;
        }

        public Builder reserved(ASN1OctetString reserved) {
            this.value = reserved;
            return this;
        }

        public HashedData createHashedData() {
            return new HashedData(this.choice, this.value);
        }
    }
}

