/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SignerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedData;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class SignedData
extends ASN1Object {
    private final HashAlgorithm hashId;
    private final ToBeSignedData tbsData;
    private final SignerIdentifier signer;
    private final Signature signature;

    public SignedData(HashAlgorithm hashId, ToBeSignedData toBeSignedData, SignerIdentifier signerIdentifier, Signature signature) {
        this.hashId = hashId;
        this.tbsData = toBeSignedData;
        this.signer = signerIdentifier;
        this.signature = signature;
    }

    public static SignedData getInstance(Object src) {
        if (src instanceof SignedData) {
            return (SignedData)src;
        }
        Iterator<ASN1Encodable> items = ASN1Sequence.getInstance(src).iterator();
        return new SignedData(HashAlgorithm.getInstance(items.next()), ToBeSignedData.getInstance(items.next()), SignerIdentifier.getInstance(items.next()), Signature.getInstance(items.next()));
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.hashId, this.tbsData, this.signer, this.signature);
    }

    public HashAlgorithm getHashId() {
        return this.hashId;
    }

    public ToBeSignedData getTbsData() {
        return this.tbsData;
    }

    public SignerIdentifier getSigner() {
        return this.signer;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Builder builder() {
        return new Builder();
    }

    public class Builder {
        private HashAlgorithm hashId;
        private ToBeSignedData tbsData;
        private SignerIdentifier signer;
        private Signature signature;

        public Builder setHashId(HashAlgorithm hashId) {
            this.hashId = hashId;
            return this;
        }

        public Builder setTbsData(ToBeSignedData tbsData) {
            this.tbsData = tbsData;
            return this;
        }

        public Builder setSigner(SignerIdentifier signer) {
            this.signer = signer;
            return this;
        }

        public Builder setSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public SignedData build() {
            return new SignedData(this.hashId, this.tbsData, this.signer, this.signature);
        }
    }
}

