/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERNull;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfCertificate;

public class SignerIdentifier
extends ASN1Object
implements ASN1Choice {
    public static final int digest = 0;
    public static final int certificate = 1;
    public static final int self = 2;
    public static final int extension = 3;
    private final int choice;
    private final ASN1Encodable object;

    public SignerIdentifier(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.object = value;
    }

    public static final SignerIdentifier getInstance(Object src) {
        if (src instanceof SignerIdentifier) {
            return (SignerIdentifier)src;
        }
        ASN1TaggedObject to = ASN1TaggedObject.getInstance(src);
        switch (to.getTagNo()) {
            case 0: {
                return new SignerIdentifier(to.getTagNo(), HashedId.HashedId8.getInstance(to.getObject()));
            }
            case 1: {
                return new SignerIdentifier(to.getTagNo(), SequenceOfCertificate.getInstance(to.getObject()));
            }
            case 2: {
                break;
            }
        }
        throw new IllegalArgumentException("unknown choice " + to.getTagNo());
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.object);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getObject() {
        return this.object;
    }

    public static class Builder {
        private ASN1Encodable encodable;
        private int choice;

        public Builder setEncodable(ASN1Encodable encodable) {
            this.encodable = encodable;
            return this;
        }

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder digest(HashedId.HashedId8 digest) {
            this.choice = 0;
            this.encodable = digest;
            return this;
        }

        public Builder certificate(SequenceOfCertificate sequenceOfCertificate) {
            this.choice = 1;
            this.encodable = sequenceOfCertificate;
            return this;
        }

        public Builder self() {
            this.choice = 2;
            this.encodable = DERNull.INSTANCE;
            return this;
        }

        public Builder extension(byte[] value) {
            this.choice = 3;
            this.encodable = new DEROctetString(value);
            return this;
        }

        public SignerIdentifier build() {
            return new SignerIdentifier(this.choice, this.encodable);
        }
    }
}

